{{-- Client Dashboard Sidebar --}}
@php
    $currentRoute = Route::currentRouteName();
    $client = Auth::guard('client')->user();
@endphp

<aside class="w-full lg:w-72 shrink-0">
    {{-- User Card --}}
    <div class="glass rounded-3xl p-6 mb-6">
        <div class="flex items-center gap-4 mb-4">
            <div class="w-16 h-16 rounded-2xl bg-gradient-to-br from-[#D4A356] to-[#A67C32] flex items-center justify-center text-black text-2xl font-black">
                {{ mb_substr($client->name ?? 'ع', 0, 1) }}
            </div>
            <div class="flex-1 min-w-0">
                <h3 class="text-white font-bold text-lg truncate">{{ $client->name }}</h3>
                <p class="text-gray-400 text-sm direction-ltr text-right">{{ $client->phone }}</p>
            </div>
        </div>
        @if($client->company)
            <div class="flex items-center gap-2 text-gray-400 text-sm">
                <svg class="w-4 h-4" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M19 21V5a2 2 0 00-2-2H7a2 2 0 00-2 2v16m14 0h2m-2 0h-5m-9 0H3m2 0h5M9 7h1m-1 4h1m4-4h1m-1 4h1m-5 10v-5a1 1 0 011-1h2a1 1 0 011 1v5m-4 0h4" />
                </svg>
                <span>{{ $client->company }}</span>
            </div>
        @endif
    </div>

    {{-- Navigation --}}
    <nav class="glass rounded-3xl overflow-hidden">
        <ul class="divide-y divide-white/5">
            {{-- لوحة التحكم --}}
            <li>
                <a href="{{ route('client.dashboard') }}"
                   class="flex items-center gap-3 px-6 py-4 transition-colors {{ $currentRoute === 'client.dashboard' ? 'bg-[#D4A356]/10 text-[#D4A356] border-r-4 border-[#D4A356]' : 'text-gray-300 hover:bg-white/5 hover:text-white' }}">
                    <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M4 5a1 1 0 011-1h14a1 1 0 011 1v2a1 1 0 01-1 1H5a1 1 0 01-1-1V5zM4 13a1 1 0 011-1h6a1 1 0 011 1v6a1 1 0 01-1 1H5a1 1 0 01-1-1v-6zM16 13a1 1 0 011-1h2a1 1 0 011 1v6a1 1 0 01-1 1h-2a1 1 0 01-1-1v-6z" />
                    </svg>
                    <span class="font-bold">لوحة التحكم</span>
                </a>
            </li>

            {{-- طلباتي --}}
            <li>
                <a href="{{ route('client.orders') }}"
                   class="flex items-center gap-3 px-6 py-4 transition-colors {{ str_starts_with($currentRoute, 'client.orders') ? 'bg-[#D4A356]/10 text-[#D4A356] border-r-4 border-[#D4A356]' : 'text-gray-300 hover:bg-white/5 hover:text-white' }}">
                    <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M16 11V7a4 4 0 00-8 0v4M5 9h14l1 12H4L5 9z" />
                    </svg>
                    <span class="font-bold">طلباتي</span>
                    @php $pendingCount = $client->orders()->where('status', 'pending')->count(); @endphp
                    @if($pendingCount > 0)
                        <span class="mr-auto bg-[#D4A356] text-black text-xs font-bold px-2 py-0.5 rounded-full">{{ $pendingCount }}</span>
                    @endif
                </a>
            </li>

            {{-- تصاميمي و ملصقاتي (للمصممين فقط) --}}
            @if($client->isDesigner())
            {{-- تصاميمي --}}
            <li>
                <a href="{{ route('client.designs') }}"
                   class="flex items-center gap-3 px-6 py-4 transition-colors {{ $currentRoute === 'client.designs' ? 'bg-[#D4A356]/10 text-[#D4A356] border-r-4 border-[#D4A356]' : 'text-gray-300 hover:bg-white/5 hover:text-white' }}">
                    <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9.53 16.122a3 3 0 00-5.78 1.128 2.25 2.25 0 01-2.4 2.245 4.5 4.5 0 008.4-2.245c0-.399-.078-.78-.22-1.128zm0 0a15.998 15.998 0 003.388-1.62m-5.043-.025a15.994 15.994 0 011.622-3.395m3.42 3.42a15.995 15.995 0 004.764-4.648l3.876-5.814a1.151 1.151 0 00-1.597-1.597L14.146 6.32a15.996 15.996 0 00-4.649 4.763m3.42 3.42a6.776 6.776 0 00-3.42-3.42" />
                    </svg>
                    <span class="font-bold">تصاميمي</span>
                    @php $designsCount = $client->designs()->count(); @endphp
                    @if($designsCount > 0)
                        <span class="mr-auto bg-pink-500/20 text-pink-400 text-xs font-bold px-2 py-0.5 rounded-full">{{ $designsCount }}</span>
                    @endif
                </a>
            </li>

            {{-- مكتبة ملصقاتي --}}
            <li>
                <a href="{{ route('client.stickers') }}"
                   class="flex items-center gap-3 px-6 py-4 transition-colors {{ $currentRoute === 'client.stickers' ? 'bg-[#D4A356]/10 text-[#D4A356] border-r-4 border-[#D4A356]' : 'text-gray-300 hover:bg-white/5 hover:text-white' }}">
                    <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M11.48 3.499a.562.562 0 011.04 0l2.125 5.111a.563.563 0 00.475.345l5.518.442c.499.04.701.663.321.988l-4.204 3.602a.563.563 0 00-.182.557l1.285 5.385a.562.562 0 01-.84.61l-4.725-2.885a.563.563 0 00-.586 0L6.982 20.54a.562.562 0 01-.84-.61l1.285-5.386a.562.562 0 00-.182-.557l-4.204-3.602a.563.563 0 01.321-.988l5.518-.442a.563.563 0 00.475-.345L11.48 3.5z" />
                    </svg>
                    <span class="font-bold">مكتبة ملصقاتي</span>
                    @php $pendingStickerCount = $client->stickers()->where('status', 'pending')->count(); @endphp
                    @if($pendingStickerCount > 0)
                        <span class="mr-auto bg-amber-500 text-black text-xs font-bold px-2 py-0.5 rounded-full">{{ $pendingStickerCount }}</span>
                    @endif
                </a>
            </li>
            @endif

            {{-- الملف الشخصي --}}
            <li>
                <a href="{{ route('client.profile') }}"
                   class="flex items-center gap-3 px-6 py-4 transition-colors {{ $currentRoute === 'client.profile' ? 'bg-[#D4A356]/10 text-[#D4A356] border-r-4 border-[#D4A356]' : 'text-gray-300 hover:bg-white/5 hover:text-white' }}">
                    <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M16 7a4 4 0 11-8 0 4 4 0 018 0zM12 14a7 7 0 00-7 7h14a7 7 0 00-7-7z" />
                    </svg>
                    <span class="font-bold">الملف الشخصي</span>
                </a>
            </li>

            {{-- عناوين الشحن --}}
            <li>
                <a href="{{ route('client.addresses') }}"
                   class="flex items-center gap-3 px-6 py-4 transition-colors {{ $currentRoute === 'client.addresses' ? 'bg-[#D4A356]/10 text-[#D4A356] border-r-4 border-[#D4A356]' : 'text-gray-300 hover:bg-white/5 hover:text-white' }}">
                    <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M17.657 16.657L13.414 20.9a1.998 1.998 0 01-2.827 0l-4.244-4.243a8 8 0 1111.314 0z" />
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M15 11a3 3 0 11-6 0 3 3 0 016 0z" />
                    </svg>
                    <span class="font-bold">عناوين الشحن</span>
                </a>
            </li>

            {{-- خط فاصل --}}
            <li class="!border-t-0">
                <div class="h-2 bg-white/5"></div>
            </li>

            {{-- الصفحة الرئيسية --}}
            <li>
                <a href="{{ route('home') }}"
                   class="flex items-center gap-3 px-6 py-4 text-gray-300 hover:bg-white/5 hover:text-white transition-colors">
                    <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M3 12l2-2m0 0l7-7 7 7M5 10v10a1 1 0 001 1h3m10-11l2 2m-2-2v10a1 1 0 01-1 1h-3m-6 0a1 1 0 001-1v-4a1 1 0 011-1h2a1 1 0 011 1v4a1 1 0 001 1m-6 0h6" />
                    </svg>
                    <span class="font-bold">الصفحة الرئيسية</span>
                </a>
            </li>

            {{-- المتجر --}}
            <li>
                <a href="{{ route('shop') }}"
                   class="flex items-center gap-3 px-6 py-4 text-gray-300 hover:bg-white/5 hover:text-white transition-colors">
                    <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M19 11H5m14 0a2 2 0 012 2v6a2 2 0 01-2 2H5a2 2 0 01-2-2v-6a2 2 0 012-2m14 0V9a2 2 0 00-2-2M5 11V9a2 2 0 012-2m0 0V5a2 2 0 012-2h6a2 2 0 012 2v2M7 7h10" />
                    </svg>
                    <span class="font-bold">المتجر</span>
                </a>
            </li>

            {{-- تسجيل الخروج --}}
            <li>
                <form action="{{ route('client.logout') }}" method="POST">
                    @csrf
                    <button type="submit"
                            class="w-full flex items-center gap-3 px-6 py-4 text-red-400 hover:bg-red-500/10 hover:text-red-300 transition-colors">
                        <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M17 16l4-4m0 0l-4-4m4 4H7m6 4v1a3 3 0 01-3 3H6a3 3 0 01-3-3V7a3 3 0 013-3h4a3 3 0 013 3v1" />
                        </svg>
                        <span class="font-bold">تسجيل الخروج</span>
                    </button>
                </form>
            </li>
        </ul>
    </nav>
</aside>
