@extends('layouts.master')

@section('title', 'تصاميمي')

@section('content')
    <div class="min-h-screen bg-[#0a0a0a] py-6 lg:py-10">
        <div class="site-container">
            <div class="flex flex-col lg:flex-row gap-6 lg:items-stretch">
                {{-- Sidebar --}}
                <x-client-sidebar :pageTitle="'تصاميمي'" />

                {{-- Main Content --}}
                <main class="flex-1 min-w-0">
                    {{-- Page Header (Desktop) --}}
                    <div class="hidden lg:block mb-6">
                        <h1 class="cairo text-2xl font-black text-white">تصاميمي</h1>
                        <p class="text-gray-500 text-sm mt-1">التصاميم التي تم تنفيذها على الموديلات</p>
                    </div>

                    {{-- Page Content --}}
                    <div class="bg-[#111111] rounded-2xl border border-white/5 p-4 sm:p-6">
                        @if($designs->isEmpty())
                            <div class="p-8 text-center">
                                <div class="w-14 h-14 mx-auto mb-3 rounded-xl bg-pink-500/10 flex items-center justify-center">
                                    <svg class="w-8 h-8 text-pink-400" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="1.5" d="M9.53 16.122a3 3 0 00-5.78 1.128 2.25 2.25 0 01-2.4 2.245 4.5 4.5 0 008.4-2.245c0-.399-.078-.78-.22-1.128zm0 0a15.998 15.998 0 003.388-1.62m-5.043-.025a15.994 15.994 0 011.622-3.395m3.42 3.42a15.995 15.995 0 004.764-4.648l3.876-5.814a1.151 1.151 0 00-1.597-1.597L14.146 6.32a15.996 15.996 0 00-4.649 4.763m3.42 3.42a6.776 6.776 0 00-3.42-3.42" />
                                    </svg>
                                </div>
                                <h3 class="text-white font-bold mb-2">لا توجد تصاميم بعد</h3>
                                <p class="text-gray-500 text-sm mb-5">ابدأ بتصميم منتجاتك من خلال المحرر ثلاثي الأبعاد</p>
                                <a href="{{ route('designs.index') }}" class="inline-flex items-center gap-2 px-5 py-2.5 rounded-xl bg-gradient-to-r from-[#D4A356] to-[#442247] text-black font-bold text-sm">
                                    تصفح الموديلات
                                </a>
                            </div>
                        @else
                            <div class="grid grid-cols-2 md:grid-cols-3 gap-4 md:gap-6">
                                @foreach($designs as $design)
                                    <a href="{{ route('configurator.show', $design->product_model_id) }}" class="block group">
                                        <div class="aspect-square rounded-xl bg-[#1a1a1a] overflow-hidden ring-1 ring-white/5 group-hover:ring-[#D4A356]/30 transition-all">
                                            @if($design->preview_image_url)
                                                <img src="{{ $design->preview_image_url }}" alt="{{ $design->name }}" class="w-full h-full object-cover group-hover:scale-105 transition-transform duration-300">
                                            @else
                                                <div class="w-full h-full flex items-center justify-center text-gray-600">
                                                    <svg class="w-10 h-10" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="1" d="M4 16l4.586-4.586a2 2 0 012.828 0L16 16m-2-2l1.586-1.586a2 2 0 012.828 0L20 14m-6-6h.01M6 20h12a2 2 0 002-2V6a2 2 0 00-2-2H6a2 2 0 00-2 2v12a2 2 0 002 2z" />
                                                    </svg>
                                                </div>
                                            @endif
                                        </div>
                                        <div class="mt-2">
                                            <p class="text-white text-sm font-bold truncate">{{ $design->name }}</p>
                                            <p class="text-gray-500 text-xs">{{ $design->productModel?->name }}</p>
                                            <div class="flex items-center gap-3 mt-1 text-xs text-gray-500">
                                                <span class="flex items-center gap-1">
                                                    <svg class="w-3 h-3" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M2.036 12.322a1.012 1.012 0 010-.639C3.423 7.51 7.36 4.5 12 4.5c4.638 0 8.573 3.007 9.963 7.178.07.207.07.431 0 .639C20.577 16.49 16.64 19.5 12 19.5c-4.638 0-8.573-3.007-9.963-7.178z" /><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M15 12a3 3 0 11-6 0 3 3 0 016 0z" /></svg>
                                                    {{ $design->views_count }}
                                                </span>
                                                <span class="flex items-center gap-1">
                                                    <svg class="w-3 h-3" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M21 8.25c0-2.485-2.099-4.5-4.688-4.5-1.935 0-3.597 1.126-4.312 2.733-.715-1.607-2.377-2.733-4.313-2.733C5.1 3.75 3 5.765 3 8.25c0 7.22 9 12 9 12s9-4.78 9-12z" /></svg>
                                                    {{ $design->likes_count }}
                                                </span>
                                                <span>{{ $design->created_at->diffForHumans() }}</span>
                                            </div>
                                            @if($design->is_public)
                                                <span class="inline-block mt-1 px-2 py-0.5 rounded-md text-[10px] font-bold bg-emerald-500/20 text-emerald-400">عام</span>
                                            @else
                                                <span class="inline-block mt-1 px-2 py-0.5 rounded-md text-[10px] font-bold bg-gray-500/20 text-gray-400">خاص</span>
                                            @endif
                                        </div>
                                    </a>
                                @endforeach
                            </div>

                            <div class="mt-6">
                                {{ $designs->links() }}
                            </div>
                        @endif
                    </div>
                </main>
            </div>
        </div>
    </div>
@endsection
