@extends('layouts.master')

@section('title', 'لوحة التحكم')

@section('content')
    <div class="min-h-screen bg-[#0a0a0a] py-6 lg:py-10">
        <div class="site-container">
            <div class="flex flex-col lg:flex-row gap-6 lg:items-stretch">
                {{-- Sidebar --}}
                <x-client-sidebar :pageTitle="'لوحة التحكم'" />

                {{-- Main Content --}}
                <main class="flex-1 min-w-0">
                    {{-- Page Header (Desktop) --}}
                    <div class="hidden lg:block mb-6">
                        <h1 class="cairo text-2xl font-black text-white">
                            @if(auth('client')->user()->isDesigner())
                                استديو المصمم
                            @else
                                لوحة التحكم
                            @endif
                        </h1>
                        <p class="text-gray-500 text-sm mt-1">مرحباً {{ auth('client')->user()->name }}، نتمنى لك يوماً سعيداً</p>
                    </div>

                    {{-- ═══════════════════════════════════════════════════
                         DESIGNER DASHBOARD
                         ═══════════════════════════════════════════════════ --}}
                    @if(auth('client')->user()->isDesigner())
                        {{-- Designer Stats --}}
                        <div class="grid grid-cols-2 lg:grid-cols-4 gap-3 sm:gap-4 mb-6">
                            <div class="bg-gradient-to-br from-pink-500/10 to-pink-500/5 rounded-xl p-4 border border-pink-500/20 hover:border-pink-500/40 transition-all group">
                                <div class="flex items-center gap-4">
                                    <div class="w-12 h-12 rounded-xl bg-pink-500/20 flex items-center justify-center group-hover:scale-110 transition-transform">
                                        <svg class="w-6 h-6 text-pink-400" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="1.5" d="M9.53 16.122a3 3 0 00-5.78 1.128 2.25 2.25 0 01-2.4 2.245 4.5 4.5 0 008.4-2.245c0-.399-.078-.78-.22-1.128zm0 0a15.998 15.998 0 003.388-1.62m-5.043-.025a15.994 15.994 0 011.622-3.395m3.42 3.42a15.995 15.995 0 004.764-4.648l3.876-5.814a1.151 1.151 0 00-1.597-1.597L14.146 6.32a15.996 15.996 0 00-4.649 4.763m3.42 3.42a6.776 6.776 0 00-3.42-3.42" />
                                        </svg>
                                    </div>
                                    <div>
                                        <p class="text-2xl lg:text-3xl font-black text-white">{{ number_format($designerStats['total_designs']) }}</p>
                                        <p class="text-gray-400 text-sm cairo font-bold">تصاميمي</p>
                                    </div>
                                </div>
                            </div>

                            <div class="bg-gradient-to-br from-emerald-500/10 to-emerald-500/5 rounded-xl p-4 border border-emerald-500/20 hover:border-emerald-500/40 transition-all group">
                                <div class="flex items-center gap-4">
                                    <div class="w-12 h-12 rounded-xl bg-emerald-500/20 flex items-center justify-center group-hover:scale-110 transition-transform">
                                        <svg class="w-6 h-6 text-emerald-400" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="1.5" d="M9 12.75L11.25 15 15 9.75M21 12a9 9 0 11-18 0 9 9 0 0118 0z"/>
                                        </svg>
                                    </div>
                                    <div>
                                        <p class="text-2xl lg:text-3xl font-black text-white">{{ number_format($designerStats['approved_stickers']) }}</p>
                                        <p class="text-gray-400 text-sm cairo font-bold">ملصقات معتمدة</p>
                                    </div>
                                </div>
                            </div>

                            <div class="bg-gradient-to-br from-amber-500/10 to-amber-500/5 rounded-xl p-4 border border-amber-500/20 hover:border-amber-500/40 transition-all group">
                                <div class="flex items-center gap-4">
                                    <div class="w-12 h-12 rounded-xl bg-amber-500/20 flex items-center justify-center group-hover:scale-110 transition-transform">
                                        <svg class="w-6 h-6 text-amber-400" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="1.5" d="M12 6v6h4.5m4.5 0a9 9 0 11-18 0 9 9 0 0118 0z" />
                                        </svg>
                                    </div>
                                    <div>
                                        <p class="text-2xl lg:text-3xl font-black text-white">{{ number_format($designerStats['pending_stickers']) }}</p>
                                        <p class="text-gray-400 text-sm cairo font-bold">قيد المراجعة</p>
                                    </div>
                                </div>
                            </div>

                            <div class="bg-gradient-to-br from-cyan-500/10 to-cyan-500/5 rounded-xl p-4 border border-cyan-500/20 hover:border-cyan-500/40 transition-all group">
                                <div class="flex items-center gap-4">
                                    <div class="w-12 h-12 rounded-xl bg-cyan-500/20 flex items-center justify-center group-hover:scale-110 transition-transform">
                                        <svg class="w-6 h-6 text-cyan-400" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="1.5" d="M11.48 3.499a.562.562 0 011.04 0l2.125 5.111a.563.563 0 00.475.345l5.518.442c.499.04.701.663.321.988l-4.204 3.602a.563.563 0 00-.182.557l1.285 5.385a.562.562 0 01-.84.61l-4.725-2.885a.563.563 0 00-.586 0L6.982 20.54a.562.562 0 01-.84-.61l1.285-5.386a.562.562 0 00-.182-.557l-4.204-3.602a.563.563 0 01.321-.988l5.518-.442a.563.563 0 00.475-.345L11.48 3.5z" />
                                        </svg>
                                    </div>
                                    <div>
                                        <p class="text-2xl lg:text-3xl font-black text-white">{{ number_format($designerStats['total_stickers']) }}</p>
                                        <p class="text-gray-400 text-sm cairo font-bold">إجمالي الملصقات</p>
                                    </div>
                                </div>
                            </div>
                        </div>

                        {{-- Recent Designs --}}
                        <div class="bg-[#111111] rounded-2xl border border-white/5 p-4 sm:p-6 mb-6">
                            <div class="flex items-center justify-between mb-4">
                                <h2 class="cairo text-lg font-black text-white flex items-center gap-2">
                                    <svg class="w-5 h-5 text-pink-400" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9.53 16.122a3 3 0 00-5.78 1.128 2.25 2.25 0 01-2.4 2.245 4.5 4.5 0 008.4-2.245c0-.399-.078-.78-.22-1.128zm0 0a15.998 15.998 0 003.388-1.62m-5.043-.025a15.994 15.994 0 011.622-3.395m3.42 3.42a15.995 15.995 0 004.764-4.648l3.876-5.814a1.151 1.151 0 00-1.597-1.597L14.146 6.32a15.996 15.996 0 00-4.649 4.763m3.42 3.42a6.776 6.776 0 00-3.42-3.42" />
                                    </svg>
                                    تصاميمي الأخيرة
                                </h2>
                                <a href="{{ route('client.designs') }}" class="text-[#D4A356] text-sm font-bold hover:underline flex items-center gap-1">
                                    عرض الكل
                                    <svg class="w-4 h-4 rotate-180" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 5l7 7-7 7"/>
                                    </svg>
                                </a>
                            </div>

                            @if(!empty($recentDesigns) && count($recentDesigns) > 0)
                                <div class="grid grid-cols-2 sm:grid-cols-3 lg:grid-cols-4 gap-4">
                                    @foreach($recentDesigns as $design)
                                    <a href="{{ route('configurator.show', $design->product_model_id) }}" class="block group">
                                        <div class="aspect-square rounded-xl bg-[#1a1a1a] overflow-hidden ring-1 ring-white/5 group-hover:ring-[#D4A356]/50 group-hover:scale-[1.02] transition-all">
                                            @if($design->preview_image_url)
                                                <img src="{{ $design->preview_image_url }}" alt="{{ $design->name }}" class="w-full h-full object-cover">
                                            @else
                                                <div class="w-full h-full flex items-center justify-center text-gray-600">
                                                    <svg class="w-10 h-10" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="1" d="M4 16l4.586-4.586a2 2 0 012.828 0L16 16m-2-2l1.586-1.586a2 2 0 012.828 0L20 14m-6-6h.01M6 20h12a2 2 0 002-2V6a2 2 0 00-2-2H6a2 2 0 00-2 2v12a2 2 0 002 2z" />
                                                    </svg>
                                                </div>
                                            @endif
                                        </div>
                                        <div class="mt-2">
                                            <p class="cairo text-white text-sm font-bold truncate">{{ $design->name }}</p>
                                            <div class="flex items-center justify-between mt-1">
                                                <span class="text-gray-500 text-xs">{{ $design->created_at->diffForHumans() }}</span>
                                                @if($design->is_public)
                                                    <span class="px-2 py-0.5 rounded-md text-[10px] font-bold bg-emerald-500/20 text-emerald-400">عام</span>
                                                @endif
                                            </div>
                                        </div>
                                    </a>
                                    @endforeach
                                </div>
                            @else
                                <div class="p-8 text-center">
                                    <div class="w-14 h-14 mx-auto mb-3 rounded-xl bg-pink-500/10 flex items-center justify-center">
                                        <svg class="w-8 h-8 text-pink-400" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="1.5" d="M9.53 16.122a3 3 0 00-5.78 1.128 2.25 2.25 0 01-2.4 2.245 4.5 4.5 0 008.4-2.245c0-.399-.078-.78-.22-1.128zm0 0a15.998 15.998 0 003.388-1.62m-5.043-.025a15.994 15.994 0 011.622-3.395m3.42 3.42a15.995 15.995 0 004.764-4.648l3.876-5.814a1.151 1.151 0 00-1.597-1.597L14.146 6.32a15.996 15.996 0 00-4.649 4.763m3.42 3.42a6.776 6.776 0 00-3.42-3.42" />
                                        </svg>
                                    </div>
                                    <h3 class="cairo text-white font-bold mb-2">لا توجد تصاميم بعد</h3>
                                    <p class="text-gray-500 text-sm mb-5">ابدأ بتصميم منتجاتك من خلال المحرر ثلاثي الأبعاد</p>
                                </div>
                            @endif
                        </div>

                        {{-- Recent Stickers --}}
                        <div class="bg-[#111111] rounded-2xl border border-white/5 p-4 sm:p-6">
                            <div class="flex items-center justify-between mb-4">
                                <h2 class="cairo text-lg font-black text-white flex items-center gap-2">
                                    <svg class="w-5 h-5 text-cyan-400" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M11.48 3.499a.562.562 0 011.04 0l2.125 5.111a.563.563 0 00.475.345l5.518.442c.499.04.701.663.321.988l-4.204 3.602a.563.563 0 00-.182.557l1.285 5.385a.562.562 0 01-.84.61l-4.725-2.885a.563.563 0 00-.586 0L6.982 20.54a.562.562 0 01-.84-.61l1.285-5.386a.562.562 0 00-.182-.557l-4.204-3.602a.563.563 0 01.321-.988l5.518-.442a.563.563 0 00.475-.345L11.48 3.5z" />
                                    </svg>
                                    مكتبة ملصقاتي
                                </h2>
                                <div class="flex items-center gap-2">
                                    <a href="{{ route('client.stickers') }}" class="text-[#D4A356] text-sm font-bold hover:underline flex items-center gap-1">
                                        عرض الكل
                                        <svg class="w-4 h-4 rotate-180" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 5l7 7-7 7"/>
                                        </svg>
                                    </a>
                                    <button onclick="document.getElementById('stickerUploadModal').classList.remove('hidden')"
                                            class="inline-flex items-center gap-1 px-3 py-1.5 rounded-lg bg-[#D4A356]/10 hover:bg-[#D4A356]/20 text-[#D4A356] text-xs font-bold transition-all">
                                        <svg class="w-4 h-4" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 4.5v15m7.5-7.5h-15" />
                                        </svg>
                                        رفع ملصق
                                    </button>
                                </div>
                            </div>

                            @php
                                $recentStickers = auth('client')->user()->stickers()->latest()->take(8)->get();
                            @endphp

                            @if($recentStickers->count() > 0)
                                <div class="grid grid-cols-2 sm:grid-cols-4 lg:grid-cols-6 gap-3">
                                    @foreach($recentStickers as $sticker)
                                        <div class="bg-white/5 rounded-xl overflow-hidden ring-1 ring-white/5 hover:ring-white/10 transition-all group">
                                            <div class="aspect-square bg-[#1a1a1a] flex items-center justify-center p-3">
                                                @if($sticker->image_url)
                                                    <img src="{{ $sticker->image_url }}" alt="{{ $sticker->name }}" class="max-w-full max-h-full object-contain group-hover:scale-110 transition-transform">
                                                @else
                                                    <svg class="w-10 h-10 text-gray-600" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="1" d="M4 16l4.586-4.586a2 2 0 012.828 0L16 16m-2-2l1.586-1.586a2 2 0 012.828 0L20 14m-6-6h.01M6 20h12a2 2 0 002-2V6a2 2 0 00-2-2H6a2 2 0 00-2 2v12a2 2 0 002 2z" />
                                                    </svg>
                                                @endif
                                            </div>
                                            <div class="p-2">
                                                <p class="cairo text-white text-xs font-bold truncate">{{ $sticker->name }}</p>
                                                @php
                                                    $statusColors = [
                                                        'pending' => 'bg-amber-500/20 text-amber-400',
                                                        'approved' => 'bg-emerald-500/20 text-emerald-400',
                                                        'rejected' => 'bg-red-500/20 text-red-400',
                                                    ];
                                                    $statusLabels = [
                                                        'pending' => 'قيد المراجعة',
                                                        'approved' => 'معتمد',
                                                        'rejected' => 'مرفوض',
                                                    ];
                                                @endphp
                                                <span class="inline-block mt-1 px-2 py-0.5 rounded-md text-[9px] font-bold {{ $statusColors[$sticker->status] ?? 'bg-gray-500/20 text-gray-400' }}">
                                                    {{ $statusLabels[$sticker->status] ?? $sticker->status }}
                                                </span>
                                            </div>
                                        </div>
                                    @endforeach
                                </div>
                            @else
                                <div class="p-8 text-center">
                                    <div class="w-14 h-14 mx-auto mb-3 rounded-xl bg-cyan-500/10 flex items-center justify-center">
                                        <svg class="w-8 h-8 text-cyan-400" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="1.5" d="M11.48 3.499a.562.562 0 011.04 0l2.125 5.111a.563.563 0 00.475.345l5.518.442c.499.04.701.663.321.988l-4.204 3.602a.563.563 0 00-.182.557l1.285 5.385a.562.562 0 01-.84.61l-4.725-2.885a.563.563 0 00-.586 0L6.982 20.54a.562.562 0 01-.84-.61l1.285-5.386a.562.562 0 00-.182-.557l-4.204-3.602a.563.563 0 01.321-.988l5.518-.442a.563.563 0 00.475-.345L11.48 3.5z" />
                                        </svg>
                                    </div>
                                    <h3 class="cairo text-white font-bold mb-2">لا توجد ملصقات بعد</h3>
                                    <p class="cairo text-gray-500 text-sm mb-5">ارفع أول ملصق لك ليراه العملاء</p>
                                    <button onclick="document.getElementById('stickerUploadModal').classList.remove('hidden')"
                                            class="inline-flex items-center gap-2 px-5 py-2.5 rounded-xl bg-gradient-to-r from-[#D4A356] to-[#442247] text-black font-bold text-sm hover:scale-[1.03] transition-transform">
                                        <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 4.5v15m7.5-7.5h-15" />
                                        </svg>
                                        رفع ملصق جديد
                                    </button>
                                </div>
                            @endif
                        </div>

                    @else
                    {{-- ═══════════════════════════════════════════════════
                         REGULAR CLIENT DASHBOARD (personal/company)
                         ═══════════════════════════════════════════════════ --}}
                    <div class="bg-[#111111] rounded-2xl border border-white/5 p-4 sm:p-6">
                        <div class="space-y-6">
                            {{-- Stats Grid --}}
                            <div class="grid grid-cols-2 lg:grid-cols-4 gap-3 sm:gap-4">
                                <div class="bg-white/5 rounded-xl p-4 hover:bg-white/[0.07] transition-all group">
                                    <div class="flex items-center gap-4">
                                        <div
                                            class="w-12 h-12 rounded-xl bg-[#D4A356]/10 flex items-center justify-center group-hover:scale-110 transition-transform">
                                            <svg class="w-6 h-6 text-[#D4A356]" fill="none" stroke="currentColor"
                                                viewBox="0 0 24 24">
                                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="1.5"
                                                    d="M15.75 10.5V6a3.75 3.75 0 10-7.5 0v4.5m11.356-1.993l1.263 12c.07.665-.45 1.243-1.119 1.243H4.25a1.125 1.125 0 01-1.12-1.243l1.264-12A1.125 1.125 0 015.513 7.5h12.974c.576 0 1.059.435 1.119 1.007zM8.625 10.5a.375.375 0 11-.75 0 .375.375 0 01.75 0zm7.5 0a.375.375 0 11-.75 0 .375.375 0 01.75 0z" />
                                            </svg>
                                        </div>
                                        <div>
                                            <p class="text-2xl lg:text-3xl font-black text-white">
                                                {{ number_format($stats['total_orders']) }}</p>
                                            <p class="text-gray-500 text-sm">إجمالي الطلبات</p>
                                        </div>
                                    </div>
                                </div>

                                <div class="bg-white/5 rounded-xl p-4 hover:bg-white/[0.07] transition-all group">
                                    <div class="flex items-center gap-4">
                                        <div
                                            class="w-12 h-12 rounded-xl bg-amber-500/10 flex items-center justify-center group-hover:scale-110 transition-transform">
                                            <svg class="w-6 h-6 text-amber-400" fill="none" stroke="currentColor"
                                                viewBox="0 0 24 24">
                                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="1.5"
                                                    d="M12 6v6h4.5m4.5 0a9 9 0 11-18 0 9 9 0 0118 0z" />
                                            </svg>
                                        </div>
                                        <div>
                                            <p class="text-2xl lg:text-3xl font-black text-white">
                                                {{ number_format($stats['pending_orders']) }}</p>
                                            <p class="text-gray-500 text-sm">قيد الانتظار</p>
                                        </div>
                                    </div>
                                </div>

                                <div class="bg-white/5 rounded-xl p-4 hover:bg-white/[0.07] transition-all group">
                                    <div class="flex items-center gap-4">
                                        <div
                                            class="w-12 h-12 rounded-xl bg-emerald-500/10 flex items-center justify-center group-hover:scale-110 transition-transform">
                                            <svg class="w-6 h-6 text-emerald-400" fill="none" stroke="currentColor"
                                                viewBox="0 0 24 24">
                                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="1.5"
                                                    d="M9 12.75L11.25 15 15 9.75M21 12a9 9 0 11-18 0 9 9 0 0118 0z" />
                                            </svg>
                                        </div>
                                        <div>
                                            <p class="text-2xl lg:text-3xl font-black text-white">
                                                {{ number_format($stats['delivered_orders']) }}</p>
                                            <p class="text-gray-500 text-sm">مكتملة</p>
                                        </div>
                                    </div>
                                </div>

                                <div class="bg-white/5 rounded-xl p-4 hover:bg-white/[0.07] transition-all group">
                                    <div class="flex items-center gap-4">
                                        <div
                                            class="w-12 h-12 rounded-xl bg-violet-500/10 flex items-center justify-center group-hover:scale-110 transition-transform">
                                            <svg class="w-6 h-6 text-violet-400" fill="none" stroke="currentColor"
                                                viewBox="0 0 24 24">
                                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="1.5"
                                                    d="M12 6v12m-3-2.818l.879.659c1.171.879 3.07.879 4.242 0 1.172-.879 1.172-2.303 0-3.182C13.536 12.219 12.768 12 12 12c-.725 0-1.45-.22-2.003-.659-1.106-.879-1.106-2.303 0-3.182s2.9-.879 4.006 0l.415.33M21 12a9 9 0 11-18 0 9 9 0 0118 0z" />
                                            </svg>
                                        </div>
                                        <div>
                                            <p class="text-2xl lg:text-3xl font-black text-white">
                                                {{ number_format($stats['total_spent']) }}</p>
                                            <p class="text-gray-500 text-sm">المصروفات (د.ع)</p>
                                        </div>
                                    </div>
                                </div>
                            </div>

                            {{-- Recent Orders --}}
                            <div class="bg-white/5 rounded-xl overflow-hidden">
                                <div class="px-4 py-3 border-b border-white/5 flex items-center justify-between">
                                    <h2 class="text-base font-bold text-white">آخر الطلبات</h2>
                                    <a href="{{ route('client.orders') }}"
                                        class="text-[#D4A356] text-sm font-bold hover:underline flex items-center gap-1">
                                        عرض الكل
                                        <svg class="w-4 h-4 rotate-180" fill="none" stroke="currentColor"
                                            viewBox="0 0 24 24">
                                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                                d="M9 5l7 7-7 7" />
                                        </svg>
                                    </a>
                                </div>

                                @if ($recentOrders->isEmpty())
                                    <div class="p-8 text-center">
                                        <div
                                            class="w-14 h-14 mx-auto mb-3 rounded-xl bg-[#D4A356]/10 flex items-center justify-center">
                                            <svg class="w-8 h-8 text-[#D4A356]" fill="none" stroke="currentColor"
                                                viewBox="0 0 24 24">
                                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="1.5"
                                                    d="M15.75 10.5V6a3.75 3.75 0 10-7.5 0v4.5m11.356-1.993l1.263 12c.07.665-.45 1.243-1.119 1.243H4.25a1.125 1.125 0 01-1.12-1.243l1.264-12A1.125 1.125 0 015.513 7.5h12.974c.576 0 1.059.435 1.119 1.007zM8.625 10.5a.375.375 0 11-.75 0 .375.375 0 01.75 0zm7.5 0a.375.375 0 11-.75 0 .375.375 0 01.75 0z" />
                                            </svg>
                                        </div>
                                        <h3 class="text-white font-bold mb-2">لا توجد طلبات بعد</h3>
                                        <p class="text-gray-500 text-sm mb-5">ابدأ التسوق الآن واستمتع بمنتجاتنا</p>
                                        <a href="{{ route('shop') }}"
                                            class="inline-flex items-center gap-2 px-5 py-2.5 rounded-xl bg-gradient-to-r from-[#D4A356] to-[#442247] text-black font-bold text-sm">
                                            تصفح المتجر
                                        </a>
                                    </div>
                                @else
                                    <div class="divide-y divide-white/5">
                                        @foreach ($recentOrders as $order)
                                            <a href="{{ route('client.orders.show', $order->id) }}"
                                                class="block p-4 hover:bg-white/[0.02] transition-colors">
                                                <div class="flex items-center gap-4">
                                                    {{-- Order Images --}}
                                                    <div class="flex -space-x-2 space-x-reverse">
                                                        @foreach ($order->items->take(3) as $item)
                                                            <div
                                                                class="w-10 h-10 rounded-lg bg-[#1a1a1a] overflow-hidden ring-2 ring-[#111111]">
                                                                @if ($item->product?->thumbnail_url)
                                                                    <img src="{{ $item->product->thumbnail_url }}"
                                                                        alt="" class="w-full h-full object-cover">
                                                                @else
                                                                    <div
                                                                        class="w-full h-full flex items-center justify-center text-gray-600">
                                                                        <svg class="w-5 h-5" fill="none"
                                                                            stroke="currentColor" viewBox="0 0 24 24">
                                                                            <path stroke-linecap="round"
                                                                                stroke-linejoin="round" stroke-width="1"
                                                                                d="M4 16l4.586-4.586a2 2 0 012.828 0L16 16m-2-2l1.586-1.586a2 2 0 012.828 0L20 14m-6-6h.01M6 20h12a2 2 0 002-2V6a2 2 0 00-2-2H6a2 2 0 00-2 2v12a2 2 0 002 2z" />
                                                                        </svg>
                                                                    </div>
                                                                @endif
                                                            </div>
                                                        @endforeach
                                                        @if ($order->items->count() > 3)
                                                            <div
                                                                class="w-10 h-10 rounded-lg bg-[#1a1a1a] ring-2 ring-[#111111] flex items-center justify-center text-gray-400 text-xs font-bold">
                                                                +{{ $order->items->count() - 3 }}
                                                            </div>
                                                        @endif
                                                    </div>

                                                    {{-- Order Info --}}
                                                    <div class="flex-1 min-w-0">
                                                        <div class="flex items-center gap-2 mb-1">
                                                            <span class="text-white font-bold">#{{ $order->id }}</span>
                                                            @php
                                                                $statusColors = [
                                                                    'pending' => 'bg-amber-500/20 text-amber-400',
                                                                    'processing' => 'bg-blue-500/20 text-blue-400',
                                                                    'shipped' => 'bg-violet-500/20 text-violet-400',
                                                                    'delivered' => 'bg-emerald-500/20 text-emerald-400',
                                                                    'cancelled' => 'bg-red-500/20 text-red-400',
                                                                ];
                                                                $statusLabels = [
                                                                    'pending' => 'قيد الانتظار',
                                                                    'processing' => 'قيد المعالجة',
                                                                    'shipped' => 'تم الشحن',
                                                                    'delivered' => 'تم التوصيل',
                                                                    'cancelled' => 'ملغي',
                                                                ];
                                                            @endphp
                                                            <span
                                                                class="px-2 py-0.5 rounded-md text-[10px] font-bold {{ $statusColors[$order->status->value] ?? 'bg-gray-500/20 text-gray-400' }}">
                                                                {{ $statusLabels[$order->status->value] ?? $order->status->value }}
                                                            </span>
                                                        </div>
                                                        <p class="text-gray-500 text-sm">
                                                            {{ $order->created_at->diffForHumans() }}</p>
                                                    </div>

                                                    {{-- Price --}}
                                                    <div class="text-left">
                                                        <span
                                                            class="text-[#D4A356] font-black">{{ number_format($order->grand_total) }}</span>
                                                        <span class="text-gray-500 text-sm mr-1">د.ع</span>
                                                    </div>
                                                </div>
                                            </a>
                                        @endforeach
                                    </div>
                                @endif
                            </div>
                        </div>
                    </div>
                    @endif
                </main>
            </div>
        </div>
    </div>

    {{-- Sticker Upload Modal (for designers only) --}}
    @if(auth('client')->user()->isDesigner())
        @include('client.partials.sticker-upload-modal')
    @endif
@endsection
