@extends('layouts.master')

@section('title', 'عناوين الشحن')

@section('content')
    <div class="min-h-screen bg-[#0a0a0a] py-6 lg:py-10">
        <div class="site-container">
            <div class="flex flex-col lg:flex-row gap-6 lg:items-stretch">
                {{-- Sidebar --}}
                <x-client-sidebar :pageTitle="'عناوين الشحن'" />

                {{-- Main Content --}}
                <main class="flex-1 min-w-0">
                    {{-- Page Header (Desktop) --}}
                    <div class="hidden lg:block mb-6">
                        <h1 class="cairo text-2xl font-black text-white">عناوين الشحن</h1>
                        <p class="text-gray-500 text-sm mt-1">إدارة عناوين التوصيل الخاصة بك</p>
                    </div>

                    {{-- Page Content --}}
                    <div class="bg-[#111111] rounded-2xl border border-white/5 p-4 sm:p-6">
                        <div class="space-y-6" x-data="{ showAddForm: false, editingId: null }">
                            {{-- Success/Error Messages --}}
                            @if (session('success'))
                                <div
                                    class="p-4 rounded-xl bg-emerald-500/10 border border-emerald-500/20 text-emerald-300 flex items-center gap-3">
                                    <svg class="w-5 h-5 shrink-0" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                            d="M9 12l2 2 4-4m6 2a9 9 0 11-18 0 9 9 0 0118 0z" />
                                    </svg>
                                    {{ session('success') }}
                                </div>
                            @endif

                            @if (session('error'))
                                <div
                                    class="p-4 rounded-xl bg-red-500/10 border border-red-500/20 text-red-300 flex items-center gap-3">
                                    <svg class="w-5 h-5 shrink-0" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                            d="M12 8v4m0 4h.01M21 12a9 9 0 11-18 0 9 9 0 0118 0z" />
                                    </svg>
                                    {{ session('error') }}
                                </div>
                            @endif

                            {{-- Add Button --}}
                            <div class="flex justify-end">
                                <button @click="showAddForm = !showAddForm; editingId = null"
                                    class="px-5 py-2.5 rounded-xl bg-gradient-to-r from-[#D4A356] to-[#442247] text-black font-bold hover:shadow-lg hover:shadow-[#D4A356]/20 transition-all flex items-center gap-2 text-sm">
                                    <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                            d="M12 4v16m8-8H4" />
                                    </svg>
                                    إضافة عنوان
                                </button>
                            </div>

                            {{-- Add Address Form --}}
                            <div x-show="showAddForm" x-collapse
                                class="bg-[#111111] rounded-3xl border border-white/10 overflow-hidden">
                                <div class="px-6 py-5 border-b border-white/10 flex items-center justify-between">
                                    <h3 class="text-lg font-bold text-white">إضافة عنوان جديد</h3>
                                    <button @click="showAddForm = false" class="text-gray-400 hover:text-white">
                                        <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                                d="M6 18L18 6M6 6l12 12" />
                                        </svg>
                                    </button>
                                </div>

                                <form action="{{ route('client.addresses.store') }}" method="POST" class="p-6">
                                    @csrf
                                    <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                                        <div>
                                            <label class="block text-sm font-bold text-gray-300 mb-2">اسم المستلم</label>
                                            <input type="text" name="name" required
                                                class="w-full px-4 py-3 rounded-2xl bg-white/5 border border-white/10 focus:border-[#D4A356] focus:ring-2 focus:ring-[#D4A356]/20 outline-none transition-all text-white"
                                                placeholder="الاسم الكامل">
                                        </div>

                                        <div>
                                            <label class="block text-sm font-bold text-gray-300 mb-2">رقم الهاتف</label>
                                            <input type="text" name="phone" required
                                                class="w-full px-4 py-3 rounded-2xl bg-white/5 border border-white/10 focus:border-[#D4A356] focus:ring-2 focus:ring-[#D4A356]/20 outline-none transition-all text-white"
                                                placeholder="07xxxxxxxxx">
                                        </div>

                                        <div>
                                            <label class="block text-sm font-bold text-gray-300 mb-2">المدينة</label>
                                            <select name="city_id" required
                                                class="w-full px-4 py-3 rounded-2xl bg-white/5 border border-white/10 focus:border-[#D4A356] focus:ring-2 focus:ring-[#D4A356]/20 outline-none transition-all text-white">
                                                <option value="">اختر المدينة</option>
                                                @foreach ($cities as $city)
                                                    <option value="{{ $city->id }}">{{ $city->name }}</option>
                                                @endforeach
                                            </select>
                                        </div>

                                        <div>
                                            <label class="flex items-center gap-3 cursor-pointer h-full pt-8">
                                                <input type="checkbox" name="is_default" value="1"
                                                    class="sr-only peer">
                                                <div
                                                    class="w-5 h-5 rounded-lg border-2 border-white/20 peer-checked:border-[#D4A356] peer-checked:bg-[#D4A356] transition-all relative">
                                                    <svg class="w-3 h-3 absolute top-1 right-1 text-black opacity-0 peer-checked:opacity-100"
                                                        fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                                        <path stroke-linecap="round" stroke-linejoin="round"
                                                            stroke-width="3" d="M5 13l4 4L19 7" />
                                                    </svg>
                                                </div>
                                                <span class="text-gray-300">تعيين كعنوان افتراضي</span>
                                            </label>
                                        </div>

                                        <div class="md:col-span-2">
                                            <label class="block text-sm font-bold text-gray-300 mb-2">العنوان
                                                التفصيلي</label>
                                            <textarea name="address" rows="3" required
                                                class="w-full px-4 py-3 rounded-2xl bg-white/5 border border-white/10 focus:border-[#D4A356] focus:ring-2 focus:ring-[#D4A356]/20 outline-none transition-all text-white resize-none"
                                                placeholder="المنطقة، الشارع، أقرب نقطة دالة..."></textarea>
                                        </div>
                                    </div>

                                    <div class="mt-6 flex justify-end gap-3">
                                        <button type="button" @click="showAddForm = false"
                                            class="px-6 py-3 rounded-full bg-white/5 text-white font-bold hover:bg-white/10 transition-all">
                                            إلغاء
                                        </button>
                                        <button type="submit"
                                            class="px-6 py-3 rounded-full bg-gradient-to-r from-[#D4A356] to-[#442247] text-black font-bold hover:shadow-lg hover:shadow-[#D4A356]/20 transition-all">
                                            حفظ العنوان
                                        </button>
                                    </div>
                                </form>
                            </div>

                            {{-- Addresses List --}}
                            @if ($addresses->isEmpty())
                                <div class="bg-[#111111] rounded-3xl border border-white/10 p-12 text-center">
                                    <div
                                        class="w-20 h-20 mx-auto mb-4 rounded-full bg-[#D4A356]/10 flex items-center justify-center">
                                        <svg class="w-10 h-10 text-[#D4A356]" fill="none" stroke="currentColor"
                                            viewBox="0 0 24 24">
                                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="1.5"
                                                d="M15 10.5a3 3 0 11-6 0 3 3 0 016 0z" />
                                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="1.5"
                                                d="M19.5 10.5c0 7.142-7.5 11.25-7.5 11.25S4.5 17.642 4.5 10.5a7.5 7.5 0 1115 0z" />
                                        </svg>
                                    </div>
                                    <h3 class="text-white font-bold text-lg mb-2">لا توجد عناوين</h3>
                                    <p class="text-gray-400 text-sm mb-6">أضف عنوان شحن لتسهيل عملية الطلب</p>
                                    <button @click="showAddForm = true"
                                        class="inline-flex items-center gap-2 px-6 py-3 rounded-full bg-gradient-to-r from-[#D4A356] to-[#442247] text-black font-bold">
                                        <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                                d="M12 4v16m8-8H4" />
                                        </svg>
                                        إضافة عنوان
                                    </button>
                                </div>
                            @else
                                <div class="grid grid-cols-1 md:grid-cols-2 gap-4">
                                    @foreach ($addresses as $address)
                                        <div
                                            class="bg-[#111111] rounded-3xl border border-white/10 overflow-hidden {{ $address->is_default ? 'ring-2 ring-[#D4A356]/50' : '' }}">
                                            <div class="p-6">
                                                <div class="flex items-start justify-between mb-4">
                                                    <div class="flex items-center gap-3">
                                                        <div
                                                            class="w-12 h-12 rounded-2xl bg-[#D4A356]/15 flex items-center justify-center">
                                                            <svg class="w-6 h-6 text-[#D4A356]" fill="none"
                                                                stroke="currentColor" viewBox="0 0 24 24">
                                                                <path stroke-linecap="round" stroke-linejoin="round"
                                                                    stroke-width="1.5"
                                                                    d="M15 10.5a3 3 0 11-6 0 3 3 0 016 0z" />
                                                                <path stroke-linecap="round" stroke-linejoin="round"
                                                                    stroke-width="1.5"
                                                                    d="M19.5 10.5c0 7.142-7.5 11.25-7.5 11.25S4.5 17.642 4.5 10.5a7.5 7.5 0 1115 0z" />
                                                            </svg>
                                                        </div>
                                                        <div>
                                                            <h3 class="text-white font-bold">{{ $address->name }}</h3>
                                                            <p class="text-gray-400 text-sm">{{ $address->phone }}</p>
                                                        </div>
                                                    </div>
                                                    @if ($address->is_default)
                                                        <span
                                                            class="px-3 py-1 rounded-full text-xs font-bold bg-[#D4A356]/20 text-[#D4A356]">الافتراضي</span>
                                                    @endif
                                                </div>

                                                <p class="text-gray-300 mb-2">{{ $address->city?->name }}</p>
                                                <p class="text-gray-400 text-sm">{{ $address->address }}</p>

                                                <div class="mt-6 flex items-center gap-2">
                                                    <button
                                                        @click="editingId = editingId === {{ $address->id }} ? null : {{ $address->id }}; showAddForm = false"
                                                        class="px-4 py-2 rounded-full bg-[#D4A356]/10 text-[#D4A356] text-sm font-bold hover:bg-[#D4A356]/20 transition-all">
                                                        تعديل
                                                    </button>
                                                    @if (!$address->is_default)
                                                        <form
                                                            action="{{ route('client.addresses.default', $address->id) }}"
                                                            method="POST" class="inline">
                                                            @csrf
                                                            <button type="submit"
                                                                class="px-4 py-2 rounded-full bg-white/5 text-gray-300 text-sm font-bold hover:bg-white/10 hover:text-white transition-all">
                                                                تعيين كافتراضي
                                                            </button>
                                                        </form>
                                                    @endif
                                                    <form action="{{ route('client.addresses.delete', $address->id) }}"
                                                        method="POST" class="inline"
                                                        onsubmit="return confirm('هل أنت متأكد من حذف هذا العنوان؟')">
                                                        @csrf
                                                        @method('DELETE')
                                                        <button type="submit"
                                                            class="px-4 py-2 rounded-full bg-red-500/10 text-red-400 text-sm font-bold hover:bg-red-500/20 transition-all">
                                                            حذف
                                                        </button>
                                                    </form>
                                                </div>

                                                {{-- Edit Form --}}
                                                <div x-show="editingId === {{ $address->id }}" x-collapse
                                                    class="mt-4 pt-4 border-t border-white/10">
                                                    <form action="{{ route('client.addresses.update', $address->id) }}"
                                                        method="POST">
                                                        @csrf
                                                        @method('PUT')
                                                        <div class="grid grid-cols-1 gap-4">
                                                            <div>
                                                                <label
                                                                    class="block text-sm font-bold text-gray-300 mb-2">اسم
                                                                    المستلم</label>
                                                                <input type="text" name="name"
                                                                    value="{{ $address->name }}" required
                                                                    class="w-full px-4 py-3 rounded-2xl bg-white/5 border border-white/10 focus:border-[#D4A356] focus:ring-2 focus:ring-[#D4A356]/20 outline-none transition-all text-white">
                                                            </div>

                                                            <div>
                                                                <label
                                                                    class="block text-sm font-bold text-gray-300 mb-2">رقم
                                                                    الهاتف</label>
                                                                <input type="text" name="phone"
                                                                    value="{{ $address->phone }}" required
                                                                    class="w-full px-4 py-3 rounded-2xl bg-white/5 border border-white/10 focus:border-[#D4A356] focus:ring-2 focus:ring-[#D4A356]/20 outline-none transition-all text-white">
                                                            </div>

                                                            <div>
                                                                <label
                                                                    class="block text-sm font-bold text-gray-300 mb-2">المدينة</label>
                                                                <select name="city_id" required
                                                                    class="w-full px-4 py-3 rounded-2xl bg-white/5 border border-white/10 focus:border-[#D4A356] focus:ring-2 focus:ring-[#D4A356]/20 outline-none transition-all text-white">
                                                                    @foreach ($cities as $city)
                                                                        <option value="{{ $city->id }}"
                                                                            {{ $address->city_id == $city->id ? 'selected' : '' }}>
                                                                            {{ $city->name }}</option>
                                                                    @endforeach
                                                                </select>
                                                            </div>

                                                            <div>
                                                                <label
                                                                    class="block text-sm font-bold text-gray-300 mb-2">العنوان
                                                                    التفصيلي</label>
                                                                <textarea name="address" rows="2" required
                                                                    class="w-full px-4 py-3 rounded-2xl bg-white/5 border border-white/10 focus:border-[#D4A356] focus:ring-2 focus:ring-[#D4A356]/20 outline-none transition-all text-white resize-none">{{ $address->address }}</textarea>
                                                            </div>

                                                            <div class="flex justify-end gap-3">
                                                                <button type="button" @click="editingId = null"
                                                                    class="px-5 py-2.5 rounded-full bg-white/5 text-white font-bold hover:bg-white/10 transition-all text-sm">
                                                                    إلغاء
                                                                </button>
                                                                <button type="submit"
                                                                    class="px-5 py-2.5 rounded-full bg-gradient-to-r from-[#D4A356] to-[#442247] text-black font-bold hover:shadow-lg hover:shadow-[#D4A356]/20 transition-all text-sm">
                                                                    حفظ التعديلات
                                                                </button>
                                                            </div>
                                                        </div>
                                                    </form>
                                                </div>
                                            </div>
                                        </div>
                                    @endforeach
                                </div>
                            @endif
                        </div>
                    </div>
                </main>
            </div>
        </div>
    </div>
@endsection
