@extends('layouts.auth')
@section('title', 'التحقق من الهاتف')

@section('content')
    <div class="w-full max-w-md">
        {{-- Card --}}
        <div class="bg-[#111111] rounded-3xl border border-white/10 overflow-hidden shadow-2xl">
            {{-- Header --}}
            <div class="bg-gradient-to-r from-[#D4A356]/20 to-[#D4A356]/5 px-8 py-8 text-center">
                <div
                    class="w-20 h-20 mx-auto mb-4 rounded-full bg-gradient-to-br from-[#D4A356] to-[#442247] flex items-center justify-center">
                    <svg class="w-10 h-10 text-black" fill="none" stroke="currentColor" stroke-width="1.5"
                        viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round"
                            d="M10.5 1.5H8.25A2.25 2.25 0 006 3.75v16.5a2.25 2.25 0 002.25 2.25h7.5A2.25 2.25 0 0018 20.25V3.75a2.25 2.25 0 00-2.25-2.25H13.5m-3 0V3h3V1.5m-3 0h3m-3 18.75h3" />
                    </svg>
                </div>
                <h1 class="cairo text-2xl font-black text-white mb-2">التحقق من الهاتف</h1>
                <p class="text-gray-400 text-sm">أدخل رمز التحقق المرسل إلى هاتفك</p>
            </div>

            {{-- Form --}}
            <div class="p-8">
                <livewire:auth.verify-code />
            </div>
        </div>

        {{-- Back to Login --}}
        <div class="mt-6 text-center">
            <a href="{{ route('client.login') }}"
                class="text-gray-400 hover:text-white transition-colors flex items-center justify-center gap-2">
                <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M10 19l-7-7m0 0l7-7m-7 7h18" />
                </svg>
                العودة لتسجيل الدخول
            </a>
        </div>
    </div>
@endsection
