@extends('layouts.auth')
@section('title', 'إعادة تعيين كلمة المرور')

@section('content')
    <div class="w-full max-w-md">
        {{-- Card --}}
        <div class="bg-[#111111] rounded-3xl border border-white/10 overflow-hidden shadow-2xl">
            {{-- Header --}}
            <div class="bg-gradient-to-r from-[#D4A356]/20 to-[#D4A356]/5 px-8 py-8 text-center">
                <div
                    class="w-20 h-20 mx-auto mb-4 rounded-full bg-gradient-to-br from-[#D4A356] to-[#442247] flex items-center justify-center">
                    <svg class="w-10 h-10 text-black" fill="none" stroke="currentColor" stroke-width="1.5"
                        viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round"
                            d="M15.75 5.25a3 3 0 013 3m3 0a6 6 0 01-7.029 5.912c-.563-.097-1.159.026-1.563.43L10.5 17.25H8.25v2.25H6v2.25H2.25v-2.818c0-.597.237-1.17.659-1.591l6.499-6.499c.404-.404.527-1 .43-1.563A6 6 0 1121.75 8.25z" />
                    </svg>
                </div>
                <h1 class="cairo text-2xl font-black text-white mb-2">كلمة مرور جديدة</h1>
                <p class="text-gray-400 text-sm">أدخل كلمة المرور الجديدة لحسابك</p>
            </div>

            {{-- Form --}}
            <div class="p-8">
                <livewire:auth.reset-password-form :token="$token" />
            </div>
        </div>
    </div>
@endsection
