@extends('layouts.auth')
@section('title', 'استعادة كلمة المرور')

@section('content')
    <div class="w-full max-w-md">
        {{-- Card --}}
        <div class="bg-[#111111] rounded-3xl border border-white/10 overflow-hidden shadow-2xl">
            {{-- Header --}}
            <div class="bg-gradient-to-r from-[#D4A356]/20 to-[#D4A356]/5 px-8 py-8 text-center">
                <div
                    class="w-20 h-20 mx-auto mb-4 rounded-full bg-gradient-to-br from-[#D4A356] to-[#442247] flex items-center justify-center">
                    <svg class="w-10 h-10 text-black" fill="none" stroke="currentColor" stroke-width="1.5"
                        viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round"
                            d="M16.5 10.5V6.75a4.5 4.5 0 10-9 0v3.75m-.75 11.25h10.5a2.25 2.25 0 002.25-2.25v-6.75a2.25 2.25 0 00-2.25-2.25H6.75a2.25 2.25 0 00-2.25 2.25v6.75a2.25 2.25 0 002.25 2.25z" />
                    </svg>
                </div>
                <h1 class="cairo text-2xl font-black text-white mb-2">نسيت كلمة المرور؟</h1>
                <p class="text-gray-400 text-sm">أدخل رقم هاتفك وسنرسل لك رمز التحقق</p>
            </div>

            {{-- Form --}}
            <div class="p-8">
                <livewire:auth.forgot-password-form />
            </div>
        </div>

        {{-- Back to Login --}}
        <div class="mt-6 text-center">
            <a href="{{ route('client.login') }}"
                class="text-gray-400 hover:text-white transition-colors flex items-center justify-center gap-2">
                <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M10 19l-7-7m0 0l7-7m-7 7h18" />
                </svg>
                العودة لتسجيل الدخول
            </a>
        </div>
    </div>
@endsection
