/**
 * Livewire Bridge - Connects JavaScript functions to Livewire components
 * This file provides global functions that dispatch Livewire events
 */

// Cart functions using Livewire
window.addToCart = function(productId, qty = 1, variantId = null) {
    if (window.Livewire) {
        window.Livewire.dispatch('cart:add', { id: productId, qty: qty, variantId: variantId });
    }
};

window.openCart = function() {
    if (window.Livewire) {
        window.Livewire.dispatch('cart:open');
    }
};

window.closeCart = function() {
    // Cart drawer is closed via Livewire component's closeCart method
    // This is handled by the component itself
};

// Wishlist functions using Livewire
window.toggleWishlist = function(productId, variantId = null) {
    if (window.Livewire) {
        window.Livewire.dispatch('wishlist:toggle', { productId: productId, variantId: variantId });
    }
};

window.openWishlist = function() {
    if (window.Livewire) {
        window.Livewire.dispatch('wishlist:open');
    }
};

window.closeWishlist = function() {
    // Wishlist drawer is closed via Livewire component
};

// Compare functions using Livewire
window.toggleCompare = function(productId, variantId = null) {
    if (window.Livewire) {
        window.Livewire.dispatch('compare:toggle', { productId: productId, variantId: variantId });
    }
};

window.openCompare = function() {
    if (window.Livewire) {
        window.Livewire.dispatch('compare:open');
    }
};

window.closeCompare = function() {
    // Compare drawer is closed via Livewire component
};

// Quick View - still uses JavaScript modal
window.openQuickViewLivewire = function(productId) {
    if (window.Livewire) {
        window.Livewire.dispatch('quickview:open', { productId: productId });
    }
};

// Toast notifications via Livewire
window.showNotification = function(type, message) {
    if (window.Livewire) {
        window.Livewire.dispatch('notification', { type: type, message: message });
    }
};

// Initialize when DOM is ready
document.addEventListener('DOMContentLoaded', function() {
    console.log('Livewire Bridge initialized');
});
