// resources/js/filament/meridiem-ar.js

function replaceMeridiemOptions(root = document) {
    const selects = root.querySelectorAll('select[x-model*="meridiem"], select[dusk*=".meridiem"]');

    selects.forEach((select) => {
        // تجنّب التكرار
        if (select.dataset.arMeridiemApplied === "1") return;

        // استبدال نص الخيارات
        [...select.options].forEach((opt) => {
            const val = (opt.value || "").toLowerCase();
            const text = (opt.textContent || "").trim().toLowerCase();

            if (val === "am" || text === "am") opt.textContent = "ص";
            if (val === "pm" || text === "pm") opt.textContent = "م";
        });

        select.dataset.arMeridiemApplied = "1";
    });
}

function bootArabicMeridiem() {
    // أول تحميل
    replaceMeridiemOptions(document);

    // عند فتح/تحديث المودالات (Filament/Livewire)
    // 1) مراقبة تغيّرات DOM
    const observer = new MutationObserver((mutations) => {
        for (const m of mutations) {
            for (const node of m.addedNodes) {
                if (node.nodeType !== 1) continue;
                replaceMeridiemOptions(node);
            }
        }
    });

    observer.observe(document.documentElement, { childList: true, subtree: true });

    // 2) بعد كل تحديث Livewire
    document.addEventListener("livewire:navigated", () => replaceMeridiemOptions(document));
    document.addEventListener("livewire:load", () => replaceMeridiemOptions(document));
    document.addEventListener("livewire:update", () => replaceMeridiemOptions(document));
}

// شغّل بعد جاهزية الصفحة
if (document.readyState === "loading") {
    document.addEventListener("DOMContentLoaded", bootArabicMeridiem);
} else {
    bootArabicMeridiem();
}
