<?php

namespace Database\Seeders;

use App\Models\User;
use App\Models\Branch;
use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Str;
use Spatie\Permission\Models\Role;
use Spatie\Permission\PermissionRegistrar;

class UserSeeder extends Seeder
{
    public function run(): void
    {
        // مزامنة كاش Spatie
        app(PermissionRegistrar::class)->forgetCachedPermissions();

        // 1) تأكيد الأدوار المختصرة (سيتم إنشاؤها إن لم تكن موجودة)
        $roleNames = [
            'admin',              // المدير العام للنظام
            'accounting_manager', // مدير الحسابات (غالباً مركزي)
            'branch_manager',     // مدير فرع
            'accountant',         // محاسب
            'warehouse_keeper',   // أمين مخزن
            'sales',              // مبيعات
            'driver',             // سائق
            'planning',           // تخطيط/تصميم/مشاريع
        ];

        $roles = collect();
        foreach ($roleNames as $name) {
            $roles[$name] = Role::firstOrCreate(['name' => $name, 'guard_name' => 'web']);
        }

        // 2) تأكد من وجود فرع واحد على الأقل
        $branch = Branch::query()->first();
        if (! $branch) {
            $branch = Branch::create([
                'city_id'    => 2,
                'name'       => 'البصرة - المركز',
                'phone'      => '07700000000',
                'address'    => 'البصرة - الجزائر',
                'status'     => 1,
                'color_base' => '#0EA5E9',
            ]);
        }

        // 3) إنشاء الأدمن (بدون city_id)
        $admin = User::firstOrCreate(
            ['email' => 'admin@example.com'],
            [
                'name'      => 'admin',
                'username'  => 'admin',
                'phone'     => '07710000000',
                'address'   => 'العراق',
                'status'    => 1,
                'branch_id' => $branch->id,   // فقط الفرع
                'password'  => Hash::make('3460015'), // غيّرها بالإنتاج
            ]
        );
        $admin->syncRoles([$roles['admin']]);

        // 4) إنشاء مستخدم مركزي لمدير الحسابات (اختياري)
        $accManager = User::firstOrCreate(
            ['email' => 'acc.manager@example.com'],
            [
                'name'      => 'accounting_manager',
                'username'  => 'acc_manager',
                'phone'     => '07710000001',
                'address'   => 'العراق',
                'status'    => 1,
                'branch_id' => $branch->id,
                'password'  => Hash::make('3460015'),
            ]
        );
        $accManager->syncRoles([$roles['accounting_manager']]);

        // 5) إنشاء مستخدمين أساسيين لكل فرع (بدون city_id)
        $branches = Branch::orderBy('id')->get();

        foreach ($branches as $br) {
            $slug = Str::slug($br->name, '_');

            // مدير فرع
            $bm = User::firstOrCreate(
                ['email' => "manager_{$slug}@example.com"],
                [
                    'name'      => "{$br->name} - manager",
                    'username'  => "manager_$br->id",
                    'status'    => 1,
                    'branch_id' => $br->id,
                    'password'  => Hash::make('3460015'),
                ]
            );
            $bm->syncRoles([$roles['branch_manager']]);

            // محاسب
            $acc = User::firstOrCreate(
                ['email' => "accountant_{$slug}@example.com"],
                [
                    'name'      => "{$br->name} - accountant",
                    'username'  => "acc_{$slug}",
                    'status'    => 1,
                    'branch_id' => $br->id,
                    'password'  => Hash::make('3460015'),
                ]
            );
            $acc->syncRoles([$roles['accountant']]);

            // أمين مخزن
            $store = User::firstOrCreate(
                ['email' => "store_{$slug}@example.com"],
                [
                    'name'      => "{$br->name} - storekeeper",
                    'username'  => "store_{$slug}",
                    'status'    => 1,
                    'branch_id' => $br->id,
                    'password'  => Hash::make('3460015'),
                ]
            );
            $store->syncRoles([$roles['warehouse_keeper']]);

            // مبيعات
            $sales = User::firstOrCreate(
                ['email' => "sales_{$slug}@example.com"],
                [
                    'name'      => "{$br->name} - sales",
                    'username'  => "sales_{$slug}",
                    'status'    => 1,
                    'branch_id' => $br->id,
                    'password'  => Hash::make('3460015'),
                ]
            );
            $sales->syncRoles([$roles['sales']]);

            // سائق
            $driver = User::firstOrCreate(
                ['email' => "driver_{$slug}@example.com"],
                [
                    'name'      => "{$br->name} - driver",
                    'username'  => "driver_{$slug}",
                    'status'    => 1,
                    'branch_id' => $br->id,
                    'password'  => Hash::make('3460015'),
                ]
            );
            $driver->syncRoles([$roles['driver']]);

            // تخطيط/تصميم
            $planner = User::firstOrCreate(
                ['email' => "planning_{$slug}@example.com"],
                [
                    'name'      => "{$br->name} - planning",
                    'username'  => "planning_{$slug}",
                    'status'    => 1,
                    'branch_id' => $br->id,
                    'password'  => Hash::make('3460015'),
                ]
            );
            $planner->syncRoles([$roles['planning']]);
        }

        // إعادة مزامنة الكاش
        app(PermissionRegistrar::class)->forgetCachedPermissions();
    }
}
