<?php

namespace Database\Seeders;

use App\Models\Branch;
use App\Models\Supplier;
use Illuminate\Database\Seeder;

class SupplierSeeder extends Seeder
{
    public function run(): void
    {
        $branch = Branch::first();

        if (! $branch) {
            return;
        }

        $suppliers = [
            [
                'name' => 'علي صالح',
                'company' => 'شركة الأخشاب الوطنية',
                'phone' => '07701111111',
                'address' => 'الشعلة - بغداد',
            ],
            [
                'name' => 'حسن محمود',
                'company' => 'مؤسسة الدهانات الحديثة',
                'phone' => '07703333333',
                'address' => 'الكرادة - بغداد',
            ],
            [
                'name' => 'أحمد كريم',
                'company' => 'معرض الإكسسوارات',
                'phone' => '07704444444',
                'address' => 'المنصور - بغداد',
            ],
            [
                'name' => 'جاسم عبد الله',
                'company' => 'شركة MDF العراقية',
                'phone' => '07705555555',
                'address' => 'الحارثية - بغداد',
            ],
            [
                'name' => 'خالد حسين',
                'company' => 'مخزن المسامير والأدوات',
                'phone' => '07706666666',
                'address' => 'اليرموك - بغداد',
            ],
            [
                'name' => 'عباس جواد',
                'company' => 'شركة الألمنيوم الجنوبية',
                'phone' => '07707777777',
                'address' => 'العشار - البصرة',
            ],
            [
                'name' => 'صادق علي',
                'company' => 'معرض الأقفال والمفصلات',
                'phone' => '07708888888',
                'address' => 'الزبير - البصرة',
            ],
            [
                'name' => 'كريم ناصر',
                'company' => 'شركة الزجاج والمرايا',
                'phone' => '07709999999',
                'address' => 'الجمهورية - البصرة',
            ],
        ];

        foreach ($suppliers as $supplier) {
            Supplier::updateOrCreate(
                ['phone' => $supplier['phone']],
                [
                    'branch_id' => $branch->id,
                    'name' => $supplier['name'],
                    'company' => $supplier['company'],
                    'address' => $supplier['address'],
                    'is_active' => true,
                ]
            );
        }
    }
}
