<?php

namespace Database\Seeders;

use App\Models\City;
use App\Models\ShippingCompany;
use App\Models\ShippingCompanyRate;
use Illuminate\Database\Seeder;

class ShippingCompanySeeder extends Seeder
{
    public function run(): void
    {
        $companies = [
            [
                'name' => 'توصيل السريع',
                'code' => 'FAST',
                'phone' => '07801234567',
                'email' => 'info@fast-delivery.iq',
                'contact_person' => 'أحمد محمد',
                'address' => 'بغداد - الكرادة',
                'is_active' => true,
            ],
            [
                'name' => 'شحن الأمين',
                'code' => 'AMIN',
                'phone' => '07709876543',
                'email' => 'contact@amin-shipping.iq',
                'contact_person' => 'علي حسين',
                'address' => 'بغداد - المنصور',
                'is_active' => true,
            ],
            [
                'name' => 'الناقل الموثوق',
                'code' => 'TRUST',
                'phone' => '07501112233',
                'email' => 'support@trusted-carrier.iq',
                'contact_person' => 'محمد عباس',
                'address' => 'البصرة - العشار',
                'is_active' => true,
            ],
        ];

        foreach ($companies as $companyData) {
            $company = ShippingCompany::firstOrCreate(
                ['code' => $companyData['code']],
                $companyData
            );

            // إضافة أسعار لكل المدن الموجودة
            $cities = City::all();
            foreach ($cities as $city) {
                ShippingCompanyRate::firstOrCreate(
                    [
                        'shipping_company_id' => $company->id,
                        'city_id' => $city->id,
                    ],
                    [
                        'fee' => rand(5000, 15000),
                        'cod_fee' => rand(1000, 3000),
                        'estimated_days' => rand(1, 5),
                        'is_active' => true,
                    ]
                );
            }
        }
    }
}
