<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use Spatie\Permission\Models\Role;
use Spatie\Permission\PermissionRegistrar;

class RolesSeeder extends Seeder
{
    public function run(): void
    {
        // تنظيف الكاش قبل الإنشاء
        app(PermissionRegistrar::class)->forgetCachedPermissions();

        /**
         * 🏢 أدوار تخص نظام إدارة شركات الأثاث المنزلي والمكتبي
         * -------------------------------------------------
         * admin             : المدير العام للنظام (صلاحيات كاملة على كل الفروع)
         * accounting_manager: مدير الحسابات - يشرف على العمليات المالية والتقارير
         * branch_manager    : مدير الفرع - يدير المبيعات والموظفين داخل الفرع
         * sales             : المبيعات - يتعامل مع العملاء والعروض والفواتير
         * accountant        : المحاسب - يتابع السندات والدفع والتحصيل
         * warehouse_keeper  : أمين المخزن - مسؤول عن المواد والمخزون والحركات
         * driver            : السائق - مسؤول عن التوصيل والنقل
         * planning          : قسم التخطيط - يضيف التصاميم للمشاريع ويتابع التنفيذ
         */

        $roles = [
            'admin',
            'accounting_manager',
            'branch_manager',
            'sales',
            'accountant',
            'warehouse_keeper',
            'driver',
            'planning',
        ];

        foreach ($roles as $role) {
            Role::firstOrCreate([
                'name'       => $role,
                'guard_name' => 'web',
            ]);
        }

        // تنظيف الكاش مجددًا حتى تتعرّف Spatie على الأدوار الجديدة فورًا
        app(PermissionRegistrar::class)->forgetCachedPermissions();
    }
}
