<?php

namespace Database\Seeders;

use App\Enums\PromotionAppliesTo;
use App\Enums\PromotionType;
use App\Models\Promotion;
use Illuminate\Database\Seeder;

class PromotionSeeder extends Seeder
{
    public function run(): void
    {
        $promotions = [
            [
                'name' => 'خصم الافتتاح 10%',
                'description' => 'خصم 10% على جميع المنتجات بمناسبة الافتتاح',
                'type' => PromotionType::Percentage,
                'discount_value' => 10,
                'applies_to' => PromotionAppliesTo::All,
                'priority' => 10,
                'is_stackable' => false,
                'starts_at' => now(),
                'ends_at' => now()->addMonths(3),
                'is_active' => true,
            ],
            [
                'name' => 'اشتري 4 واحصل على 1 مجاناً',
                'description' => 'اشتري 4 قطع من أي منتج واحصل على الخامسة مجاناً',
                'type' => PromotionType::BuyXGetY,
                'discount_value' => null,
                'buy_quantity' => 4,
                'get_quantity' => 1,
                'applies_to' => PromotionAppliesTo::All,
                'priority' => 5,
                'is_stackable' => false,
                'starts_at' => now(),
                'ends_at' => now()->addMonths(6),
                'is_active' => true,
            ],
            [
                'name' => 'شحن مجاني فوق 100 ألف',
                'description' => 'احصل على شحن مجاني عند الشراء بمبلغ 100,000 دينار أو أكثر',
                'type' => PromotionType::FreeShipping,
                'discount_value' => null,
                'min_purchase_amount' => 100000,
                'applies_to' => PromotionAppliesTo::All,
                'priority' => 8,
                'is_stackable' => true,
                'starts_at' => now(),
                'ends_at' => now()->addYear(),
                'is_active' => true,
            ],
            [
                'name' => 'خصم 5000 دينار',
                'description' => 'خصم ثابت 5000 دينار على الطلبات فوق 50,000 دينار',
                'type' => PromotionType::Fixed,
                'discount_value' => 5000,
                'min_purchase_amount' => 50000,
                'applies_to' => PromotionAppliesTo::All,
                'priority' => 3,
                'is_stackable' => false,
                'starts_at' => now(),
                'ends_at' => now()->addMonths(2),
                'is_active' => true,
            ],
        ];

        foreach ($promotions as $promotionData) {
            Promotion::firstOrCreate(
                ['name' => $promotionData['name']],
                $promotionData
            );
        }
    }
}
