<?php

namespace Database\Seeders;

use App\Models\Product;
use App\Models\ProductVariant;
use App\Models\ProductPrice;
use Illuminate\Database\Seeder;

class ProductPriceSeeder extends Seeder
{
    /**
     * تعبئة جدول الأسعار (product_prices)
     *
     * أنواع الأسعار:
     * - retail: مفرد
     * - wholesale: جملة
     * - agent: وكيل
     *
     * يمكن تحديد السعر بطريقتين:
     * 1. سعر ثابت مباشر (retail_price, wholesale_price, agent_price)
     * 2. نسبة ربح على الكلفة (retail_margin, wholesale_margin, agent_margin)
     *
     * ملاحظة: جميع القيم 0 بدلاً من null حسب تعريف الجدول
     */
    public function run(): void
    {
        // =================== أسعار المنتج البسيط: قلم حبر ===================
        $penProduct = Product::where('name', 'قلم حبر أزرق')->first();
        if ($penProduct) {
            $penVariant = $penProduct->variants()->first();

            if ($penVariant) {
                ProductPrice::firstOrCreate(
                    [
                        'product_id'         => $penProduct->id,
                        'product_variant_id' => $penVariant->id,
                    ],
                    [
                        // أسعار ثابتة (نستخدم الأسعار المباشرة)
                        'retail_price'     => 7500,   // 75 دينار (مفرد)
                        'wholesale_price'  => 6000,   // 60 دينار (جملة)
                        'agent_price'      => 5500,   // 55 دينار (وكيل)
                        // الهوامش = 0 (لأننا نستخدم الأسعار الثابتة)
                        'retail_margin'    => 0,
                        'wholesale_margin' => 0,
                        'agent_margin'     => 0,
                        'status'           => ProductPrice::STATUS_ACTIVE,
                    ]
                );

                $this->command->info("✅ تم إنشاء أسعار للمنتج: {$penProduct->name}");
            }
        }

        // =================== أسعار المنتج المتغير: قميص قطني ===================
        $tshirtProduct = Product::where('name', 'قميص قطني')->first();
        if ($tshirtProduct) {
            $variants = $tshirtProduct->variants;

            foreach ($variants as $variant) {
                ProductPrice::firstOrCreate(
                    [
                        'product_id'         => $tshirtProduct->id,
                        'product_variant_id' => $variant->id,
                    ],
                    [
                        // استخدام نسب الربح (يتم حساب السعر تلقائياً من cost)
                        'retail_price'     => 0,     // 0 = سيُحسب من الهامش
                        'wholesale_price'  => 0,     // 0 = سيُحسب من الهامش
                        'agent_price'      => 0,     // 0 = سيُحسب من الهامش
                        'retail_margin'    => 50.0,  // ربح 50% للمفرد
                        'wholesale_margin' => 35.0,  // ربح 35% للجملة
                        'agent_margin'     => 25.0,  // ربح 25% للوكيل
                        'status'           => ProductPrice::STATUS_ACTIVE,
                    ]
                );
            }

            $this->command->info("✅ تم إنشاء أسعار لكل متغيرات: {$tshirtProduct->name}");
        }

        // =================== أسعار المنتج المتغير: حذاء رياضي ===================
        $shoeProduct = Product::where('name', 'حذاء رياضي')->first();
        if ($shoeProduct) {
            $variants = $shoeProduct->variants;

            foreach ($variants as $variant) {
                ProductPrice::firstOrCreate(
                    [
                        'product_id'         => $shoeProduct->id,
                        'product_variant_id' => $variant->id,
                    ],
                    [
                        // أسعار ثابتة (نستخدم الأسعار المباشرة)
                        'retail_price'     => 500000, // 5000 دينار (ثابت)
                        'wholesale_price'  => 450000, // 4500 دينار (ثابت)
                        'agent_price'      => 420000, // 4200 دينار (ثابت)
                        // الهوامش = 0 (لأننا نستخدم الأسعار الثابتة)
                        'retail_margin'    => 0,
                        'wholesale_margin' => 0,
                        'agent_margin'     => 0,
                        'status'           => ProductPrice::STATUS_ACTIVE,
                    ]
                );
            }

            $this->command->info("✅ تم إنشاء أسعار لكل متغيرات: {$shoeProduct->name}");
        }

        // =================== أسعار المنتج المتغير: حقيبة جلدية ===================
        $bagProduct = Product::where('name', 'حقيبة جلدية')->first();
        if ($bagProduct) {
            $variants = $bagProduct->variants;

            foreach ($variants as $variant) {
                ProductPrice::firstOrCreate(
                    [
                        'product_id'         => $bagProduct->id,
                        'product_variant_id' => $variant->id,
                    ],
                    [
                        // استخدام نسب الربح (يتم حساب السعر تلقائياً من cost)
                        'retail_price'     => 0,     // 0 = سيُحسب من الهامش
                        'wholesale_price'  => 0,     // 0 = سيُحسب من الهامش
                        'agent_price'      => 0,     // 0 = سيُحسب من الهامش
                        'retail_margin'    => 60.0,  // ربح 60% للمفرد
                        'wholesale_margin' => 45.0,  // ربح 45% للجملة
                        'agent_margin'     => 35.0,  // ربح 35% للوكيل
                        'status'           => ProductPrice::STATUS_ACTIVE,
                    ]
                );
            }

            $this->command->info("✅ تم إنشاء أسعار لكل متغيرات: {$bagProduct->name}");
        }

        $this->command->info('✅✅ تم إنشاء جميع الأسعار بنجاح');
    }
}
