<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use Spatie\Permission\Models\Permission;
use Spatie\Permission\PermissionRegistrar;

class PermissionSeeder extends Seeder
{
    public function run(): void
    {
        // 🧹 امسح كاش الأذونات قبل الإنشاء
        app(PermissionRegistrar::class)->forgetCachedPermissions();

        // خريطة الأذونات لوحدات نظام الأثاث المنزلي والمكتبي
        $map = [
            // 📍 الأساس الإداري
            'cities'   => ['view', 'create', 'update', 'delete'],
            'branches' => ['view', 'create', 'update', 'delete', 'view_all'], // 👈 تمت الإضافة

            // 👥 المستخدمون والأدوار
            'users'    => ['view', 'create', 'update', 'delete', 'reset_password'],
            'roles'    => ['view', 'create', 'update', 'delete'],

            // 🧑‍💼 الموارد البشرية
            'departments'  => ['view', 'create', 'update', 'delete'],
            'pay_grades'   => ['view', 'create', 'update', 'delete'],
            'employees'    => ['view', 'create', 'update', 'delete'],

            // 📦 المخزون والمستودعات
            'warehouses'           => ['view', 'create', 'update', 'delete'],
            'inventory.items'      => ['view', 'create', 'update', 'delete'],
            'inventory.categories' => ['view', 'create', 'update', 'delete'],
            'inventory.warehouses' => ['view', 'create', 'update', 'delete'],
            'inventory.stock'      => ['view', 'in', 'out', 'transfer', 'adjust'],

            // 🧾 المبيعات
            'sales.quotations' => ['view', 'create', 'update', 'delete', 'approve', 'print', 'send'],
            'sales.invoices'   => ['view', 'create', 'update', 'delete', 'approve', 'print', 'send'],
            'sales.payments'   => ['view', 'create', 'refund'],

            // 🛒 المشتريات
            'purchases.requests'          => ['view', 'create', 'update', 'delete'],
            'purchases.orders'            => ['view', 'create', 'update', 'delete', 'approve', 'print'],
            'purchases.receipts'          => ['view', 'create', 'update', 'delete'],
            'purchases.supplier_invoices' => ['view', 'create', 'update', 'delete'],
            'purchases.supplier_payments' => ['view', 'create'],

            // 🧩 المشاريع/التصميم/الورشة
            'projects' => ['view', 'create', 'update', 'delete', 'assign', 'schedule', 'progress'],
            'designs'  => ['view', 'create', 'update', 'delete', 'approve'],

            // 🚚 التوصيل
            'delivery.tasks' => ['view', 'assign', 'update_status', 'complete'],

            // 🧮 المحاسبة والتقارير
            'accounting.vouchers'     => ['view', 'create', 'approve'],
            'accounting.expenses'     => ['view', 'create', 'update', 'delete'],
            'accounting.reports'      => ['view_finance', 'view_cashflow', 'export'],
            'accounting.treasury'     => ['view', 'deposit', 'withdraw', 'transfer', 'reconcile', 'close_day'],
            'accounting.cash_drawers' => ['view', 'open', 'close', 'settle'],

            // 📑 ملفات/تقارير عامة/إعدادات
            'files'    => ['upload', 'view', 'delete'],
            'reports'  => ['view_sales', 'view_operations', 'export'],
            'settings' => ['view', 'update'],
        ];

        // إنشاء الأذونات
        foreach ($map as $module => $actions) {
            foreach ($actions as $action) {
                Permission::firstOrCreate([
                    'name'       => "{$module}.{$action}",
                    'guard_name' => 'web',
                ]);
            }
        }

        // 🧹 امسح الكاش مجددًا
        app(PermissionRegistrar::class)->forgetCachedPermissions();
    }
}
