<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use App\Models\PayGrade;
use App\Models\Branch;

class PayGradeSeeder extends Seeder
{
    public function run(): void
    {
        // ✅ جلب الفروع
        $branches = Branch::orderBy('id')->get();
        if ($branches->isEmpty()) {
            throw new \RuntimeException('لا توجد فروع. شغّل BranchSeeder قبل PayGradeSeeder.');
        }

        // ✅ قائمة الدرجات الأساسية
        $grades = [
            ['name' => 'مدير فرع',   'amount' => 1800000],
            ['name' => 'محاسب',      'amount' =>  900000],
            ['name' => 'مبيعات',     'amount' =>  600000],
            ['name' => 'رئيس نجارين', 'amount' => 1300000],
            ['name' => 'نجار',       'amount' =>  800000],
            ['name' => 'مشرف مخزن',  'amount' =>  950000],
            ['name' => 'أمين مخزن',  'amount' =>  750000],
            ['name' => 'عامل مخزن',  'amount' =>  550000],
            ['name' => 'سائق توصيل', 'amount' =>  700000],
            ['name' => 'عامل تحميل', 'amount' =>  500000],
            ['name' => 'عامل نظافة', 'amount' =>  450000],
            ['name' => 'حارس أمن',   'amount' =>  600000],
            ['name' => 'مصمم',       'amount' => 1500000],
        ];

        // ✅ توزيعها على كل الفروع مع الحماية من التكرار
        foreach ($branches as $branch) {
            foreach ($grades as $g) {
                PayGrade::updateOrCreate(
                    [
                        'branch_id' => $branch->id,
                        'name'      => $g['name'],
                    ],
                    [
                        'amount' => $g['amount'],
                        'is_active'      => true,
                    ]
                );
            }
        }

        $this->command->info('تم إنشاء وربط الدرجات الوظيفية بكل الفروع بنجاح ✅');
    }
}
