<?php

namespace Database\Seeders;

use App\Models\User;
use Illuminate\Database\Seeder;
use Spatie\Permission\Models\Role;
use Spatie\Permission\PermissionRegistrar;

class ModelHasRolesSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        // 🧹 تنظيف كاش Spatie قبل الإسناد
        app(PermissionRegistrar::class)->forgetCachedPermissions();

        // 1) تأكد من وجود الأدوار (سيتم إنشاؤها إن لزم)
        $roleNames = [
            'admin',              // المدير العام للنظام
            'accounting_manager', // مدير الحسابات
            'branch_manager',     // مدير فرع
            'sales',              // المبيعات
            'accountant',         // المحاسب
            'warehouse_keeper',   // أمين المخزن
            'driver',             // السائق
            'planning',           // التخطيط/التصميم/المشاريع
        ];

        $roles = collect();
        foreach ($roleNames as $name) {
            $roles[$name] = Role::firstOrCreate([
                'name'       => $name,
                'guard_name' => 'web',
            ]);
        }

        // 2) إحضار المستخدمين
        $users = User::orderBy('id')->get();

        // 3) إسناد الأدوار حسب ID (نفس أسلوبك السابق ولكن بالأسماء المحدثة)
        //    يمكنك تعديل التوزيع كما تشاء.
        foreach ($users as $user) {
            switch ($user->id) {
                case 1:
                    $user->syncRoles([$roles['admin']]);               // أول مستخدم = أدمن
                    break;
                case 2:
                    $user->syncRoles([$roles['branch_manager']]);      // ثاني مستخدم = مدير فرع
                    break;
                case 3:
                    $user->syncRoles([$roles['accountant']]);          // ثالث مستخدم = محاسب
                    break;
                case 4:
                    $user->syncRoles([$roles['warehouse_keeper']]);    // رابع مستخدم = أمين مخزن
                    break;
                case 5:
                    $user->syncRoles([$roles['driver']]);              // خامس مستخدم = سائق
                    break;
                default:
                    // الدور الافتراضي للبقية
                    $user->syncRoles([$roles['sales']]);               // الباقي = مبيعات
                    break;
            }
        }

        // 🧹 تنظيف الكاش بعد الإسناد
        app(PermissionRegistrar::class)->forgetCachedPermissions();
    }
}
