<?php

namespace Database\Seeders;

use App\Models\City;
use App\Models\Branch;
use App\Models\PayGrade;
use App\Models\Employee;
use Illuminate\Database\Seeder;
use Illuminate\Support\Carbon;
use Illuminate\Support\Str;

class EmployeeSeeder extends Seeder
{
    public function run(): void
    {
        // 1) تأكيد مدينة البصرة
        $basra = City::firstOrCreate(['name' => 'البصرة'], ['is_active' => true]);

        // 2) جلب كل فروع البصرة (أو إنشاء فرع افتراضي إن لم توجد)
        $branches = Branch::where('city_id', $basra->id)->orderBy('id')->get();

        if ($branches->isEmpty()) {
            $branches = collect([
                Branch::firstOrCreate(
                    ['name' => 'البصرة - المركز', 'city_id' => $basra->id],
                    [
                        'phone'         => '07700000000',
                        'address'       => 'البصرة - الجزائر',
                        'status'        => 1,
                        'color_base'    => '#0EA5E9',
                        'color_palette' => null,
                    ]
                ),
            ]);
        }

        // 3) لكل فرع: أنشئ درجتي رواتب أساسيتين + موظفين تجريبيين
        foreach ($branches as $branch) {
            // Pay Grades لكل فرع (تعتمد فقط على name, amount, branch_id, is_active)
            $pgMonthly = PayGrade::firstOrCreate(
                ['branch_id' => $branch->id, 'name' => 'شهري A'],
                ['amount' => 800000, 'is_active' => true]
            );

            $pgDaily = PayGrade::firstOrCreate(
                ['branch_id' => $branch->id, 'name' => 'يومي A'],
                ['amount' => 30000, 'is_active' => true]
            );

            // موظفون تجريبيون (يتوافقون مع enum: monthly/daily)
            $employees = [
                [
                    'name'        => 'محمد علي',
                    'job_title'   => 'مندوب مبيعات',
                    'gender'      => 'male',
                    'salary_type' => 'monthly',
                    'pay_grade'   => $pgMonthly,
                ],
                [
                    'name'        => 'زهراء كريم',
                    'job_title'   => 'مصممة ديكور',
                    'gender'      => 'female',
                    'salary_type' => 'monthly',
                    'pay_grade'   => $pgMonthly,
                ],
                [
                    'name'        => 'حسين جاسم',
                    'job_title'   => 'نجار ورشة',
                    'gender'      => 'male',
                    'salary_type' => 'daily',
                    'pay_grade'   => $pgDaily,
                ],
                [
                    'name'        => 'سرى حيدر',
                    'job_title'   => 'أمينة مخزن',
                    'gender'      => 'female',
                    'salary_type' => 'monthly',
                    'pay_grade'   => $pgMonthly,
                ],
                [
                    'name'        => 'منتظر سامر',
                    'job_title'   => 'سائق توصيل',
                    'gender'      => 'male',
                    'salary_type' => 'daily',
                    'pay_grade'   => $pgDaily,
                ],
            ];

            $counter = 0;
            foreach ($employees as $e) {
                $counter++;
                // رقم هاتف فريد (ليس هناك unique في الجدول، لكن نضمن التفرد منطقيًا لكل فرع)
                $phone = '077' . str_pad((string)($branch->id * 100 + $counter), 8, '0', STR_PAD_LEFT);

                Employee::updateOrCreate(
                    ['branch_id' => $branch->id, 'phone' => $phone],
                    [
                        'branch_id'    => $branch->id,
                        'name'         => $e['name'],
                        'phone'        => $phone,
                        'job_title'    => $e['job_title'],
                        'address'      => 'البصرة - ' . Str::limit($branch->name, 15),
                        'gender'       => $e['gender'],                 // ['male','female'] أو null
                        'hired_at'     => Carbon::now()->subMonths(rand(1, 12))->toDateString(),
                        'salary_type'  => $e['salary_type'],            // 'monthly' | 'daily'
                        'pay_grade_id' => $e['pay_grade']->id,          // nullable في السكيمة لكن نوفره هنا
                        'is_active'    => true,
                    ]
                );
            }
        }
    }
}
