<?php

namespace Database\Seeders;

use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;

// السييدرز الحالية
class DatabaseSeeder extends Seeder
{
    use WithoutModelEvents;

    /**
     * Seed the application's database.
     */
    public function run(): void
    {
        $this->call([
            // ════════════════════════════════════════════════════════
            // 🏙️  المرحلة 1: الأساسيات (المواقع، الفروع، العملات، الدفع)
            // ════════════════════════════════════════════════════════
            CitySeeder::class,                      // 1. المحافظات / المدن
            BranchSeeder::class,                    // 2. الفروع
            BranchSettingsSeeder::class,            // 3. إعدادات الفروع
            CurrencySeeder::class,                  // 4. العملات
            PaymentMethodSeeder::class,             // 5. طرق الدفع
            // PartSeeder::class,                   // 6. المكونات (غير موجود)
            // ColorSeeder::class,                  // 7. الألوان (غير موجود)
            // ════════════════════════════════════════════════════════
            // 💰  المرحلة 2: النظام الإداري (رواتب وصلاحيات)
            // ════════════════════════════
            RolesSeeder::class,                 // 8. الأدوار
            RolesWithPermissionsSeeder::class,  // 9. ربط الأدوار بالصلاحيات

            // ════════════════════════════════════════════════════════
            // 👥  المرحلة 3: الأشخاص (مستخدمين، موظفين، عملاء، موردين، مستودعات)
            // ════════════════════════════════════════════════════════
            UserSeeder::class,                   // 10. المستخدمين (مع الأدوار)
            ModelHasRolesSeeder::class,          // 11. ربط المستخدمين بالأدوار
            ModelHasPermissionsSeeder::class,    // 12. صلاحيات مباشرة لبعض المستخدمين
            EmployeeSeeder::class,               // 13. الموظفين
            ClientSeeder::class,                 // 14. العملاء
            SupplierSeeder::class,               // 15. الموردين
            WarehouseSeeder::class,              // 16. المستودعات

            // ════════════════════════════════════════════════════════
            // 🧱  المرحلة 4: الخصائص الأساسية للمنتجات والمخزون
            // ════════════════════════════════════════════════════════
            AttributeSeeder::class,            // 17. الخصائص العامة
            AttributeValueSeeder::class,       // 18. قيم الخصائص
            // ProductAndVariantSeeder::class,    // 27. المنتجات والمتغيرات
            // ProductPriceSeeder::class,         // 28. أسعار المنتجات
            // InitialStockSeeder::class,         // 29. المخزون الابتدائي

            // ════════════════════════════════════════════════════════
            // 🛒  المرحلة 5: المتجر الإلكتروني (شحن، عروض، كوبونات)
            // ════════════════════════════════════════════════════════
            ShippingCompanySeeder::class,       // 19. شركات الشحن
            PromotionSeeder::class,             // 20. العروض والخصومات
            CouponSeeder::class,                // 21. كوبونات الخصم

        ]);
    }
}
