<?php

namespace Database\Seeders;

use App\Models\Currency;
use App\Models\ExchangeRate;
use Illuminate\Database\Seeder;

class CurrencySeeder extends Seeder
{
    public function run(): void
    {
        $iqd = Currency::updateOrCreate(
            ['code' => 'IQD'],
            [
                'name' => 'دينار عراقي',
                'symbol' => 'د.ع',
                'decimal_places' => 0,
                'position' => 'after',
                'is_default' => true,
                'is_active' => true,
            ]
        );

        $usd = Currency::updateOrCreate(
            ['code' => 'USD'],
            [
                'name' => 'دولار أمريكي',
                'symbol' => '$',
                'decimal_places' => 2,
                'position' => 'before',
                'is_default' => false,
                'is_active' => true,
            ]
        );

        // سعر الصرف: 1 USD = 1480 IQD
        ExchangeRate::updateOrCreate(
            ['currency_id' => $usd->id],
            ['rate' => 1480, 'is_active' => true]
        );
    }
}
