<?php

namespace Database\Seeders;

use App\Models\Coupon;
use Illuminate\Database\Seeder;

class CouponSeeder extends Seeder
{
    public function run(): void
    {
        $coupons = [
            // كوبونات للعملاء الجدد
            [
                'code' => 'WELCOME25',
                'name' => 'ترحيب بالعملاء الجدد',
                'description' => 'خصم 25% للعملاء الجدد على أول طلب',
                'type' => 'percentage',
                'discount_value' => 25,
                'min_purchase_amount' => 0,
                'max_discount_amount' => 50000,
                'usage_limit_total' => 10000,
                'usage_limit_per_client' => 1,
                'starts_at' => now(),
                'ends_at' => now()->addYear(),
                'is_active' => true,
            ],
            [
                'code' => 'FIRSTORDER',
                'name' => 'خصم الطلب الأول',
                'description' => 'خصم 15% على طلبك الأول',
                'type' => 'percentage',
                'discount_value' => 15,
                'min_purchase_amount' => 25000,
                'max_discount_amount' => 30000,
                'usage_limit_total' => 10000,
                'usage_limit_per_client' => 1,
                'starts_at' => now(),
                'ends_at' => now()->addMonths(6),
                'is_active' => true,
            ],

            // كوبونات خصم ثابت
            [
                'code' => 'SAVE10',
                'name' => 'وفر 10%',
                'description' => 'خصم 10% على جميع المنتجات',
                'type' => 'percentage',
                'discount_value' => 10,
                'min_purchase_amount' => 0,
                'max_discount_amount' => 25000,
                'usage_limit_total' => 500,
                'usage_limit_per_client' => 3,
                'starts_at' => now(),
                'ends_at' => now()->addMonths(3),
                'is_active' => true,
            ],
            [
                'code' => 'SAVE20',
                'name' => 'وفر 20%',
                'description' => 'خصم 20% للطلبات فوق 100,000 دينار',
                'type' => 'percentage',
                'discount_value' => 20,
                'min_purchase_amount' => 100000,
                'max_discount_amount' => 50000,
                'usage_limit_total' => 200,
                'usage_limit_per_client' => 2,
                'starts_at' => now(),
                'ends_at' => now()->addMonths(3),
                'is_active' => true,
            ],
            [
                'code' => 'MEGA30',
                'name' => 'خصم ميجا 30%',
                'description' => 'خصم 30% للطلبات فوق 150,000 دينار',
                'type' => 'percentage',
                'discount_value' => 30,
                'min_purchase_amount' => 150000,
                'max_discount_amount' => 75000,
                'usage_limit_total' => 100,
                'usage_limit_per_client' => 1,
                'starts_at' => now(),
                'ends_at' => now()->addMonths(2),
                'is_active' => true,
            ],

            // كوبونات مبلغ ثابت
            [
                'code' => 'SAVE5K',
                'name' => 'خصم 5,000 دينار',
                'description' => 'خصم 5,000 دينار على أي طلب',
                'type' => 'fixed',
                'discount_value' => 5000,
                'min_purchase_amount' => 30000,
                'max_discount_amount' => 5000,
                'usage_limit_total' => 300,
                'usage_limit_per_client' => 5,
                'starts_at' => now(),
                'ends_at' => now()->addMonths(6),
                'is_active' => true,
            ],
            [
                'code' => 'SAVE10K',
                'name' => 'خصم 10,000 دينار',
                'description' => 'خصم 10,000 دينار للطلبات فوق 75,000 دينار',
                'type' => 'fixed',
                'discount_value' => 10000,
                'min_purchase_amount' => 75000,
                'max_discount_amount' => 10000,
                'usage_limit_total' => 150,
                'usage_limit_per_client' => 3,
                'starts_at' => now(),
                'ends_at' => now()->addMonths(4),
                'is_active' => true,
            ],
            [
                'code' => 'SAVE25K',
                'name' => 'خصم 25,000 دينار',
                'description' => 'خصم 25,000 دينار للطلبات فوق 150,000 دينار',
                'type' => 'fixed',
                'discount_value' => 25000,
                'min_purchase_amount' => 150000,
                'max_discount_amount' => 25000,
                'usage_limit_total' => 50,
                'usage_limit_per_client' => 1,
                'starts_at' => now(),
                'ends_at' => now()->addMonths(2),
                'is_active' => true,
            ],

            // كوبونات شحن مجاني
            [
                'code' => 'FREESHIP',
                'name' => 'شحن مجاني',
                'description' => 'توصيل مجاني على جميع الطلبات',
                'type' => 'fixed',
                'discount_value' => 5000,
                'min_purchase_amount' => 0,
                'max_discount_amount' => 5000,
                'usage_limit_total' => 10000,
                'usage_limit_per_client' => 10,
                'starts_at' => now(),
                'ends_at' => now()->addYear(),
                'is_active' => true,
            ],
            [
                'code' => 'SHIPFREE50',
                'name' => 'شحن مجاني +50K',
                'description' => 'توصيل مجاني للطلبات فوق 50,000 دينار',
                'type' => 'fixed',
                'discount_value' => 5000,
                'min_purchase_amount' => 50000,
                'max_discount_amount' => 5000,
                'usage_limit_total' => 1000,
                'usage_limit_per_client' => 99,
                'starts_at' => now(),
                'ends_at' => now()->addYear(),
                'is_active' => true,
            ],

            // كوبونات VIP
            [
                'code' => 'VIP50',
                'name' => 'خصم VIP 50%',
                'description' => 'خصم حصري 50% لعملاء VIP',
                'type' => 'percentage',
                'discount_value' => 50,
                'min_purchase_amount' => 0,
                'max_discount_amount' => 100000,
                'usage_limit_total' => 20,
                'usage_limit_per_client' => 1,
                'starts_at' => now(),
                'ends_at' => now()->addMonths(1),
                'is_active' => true,
            ],
            [
                'code' => 'GOLD25',
                'name' => 'خصم العملاء الذهبيين',
                'description' => 'خصم 25% للعملاء الذهبيين',
                'type' => 'percentage',
                'discount_value' => 25,
                'min_purchase_amount' => 0,
                'max_discount_amount' => 75000,
                'usage_limit_total' => 100,
                'usage_limit_per_client' => 3,
                'starts_at' => now(),
                'ends_at' => now()->addMonths(6),
                'is_active' => true,
            ],

            // كوبونات المناسبات
            [
                'code' => 'EID2026',
                'name' => 'عرض العيد',
                'description' => 'خصم 20% بمناسبة العيد',
                'type' => 'percentage',
                'discount_value' => 20,
                'min_purchase_amount' => 50000,
                'max_discount_amount' => 40000,
                'usage_limit_total' => 500,
                'usage_limit_per_client' => 2,
                'starts_at' => now(),
                'ends_at' => now()->addDays(14),
                'is_active' => true,
            ],
            [
                'code' => 'WINTER26',
                'name' => 'تخفيضات الشتاء',
                'description' => 'خصم 15% على مجموعة الشتاء',
                'type' => 'percentage',
                'discount_value' => 15,
                'min_purchase_amount' => 40000,
                'max_discount_amount' => 30000,
                'usage_limit_total' => 300,
                'usage_limit_per_client' => 2,
                'starts_at' => now(),
                'ends_at' => now()->addMonths(2),
                'is_active' => true,
            ],
            [
                'code' => 'FLASH50',
                'name' => 'عرض فلاش',
                'description' => 'خصم 50% - لمدة محدودة جداً!',
                'type' => 'percentage',
                'discount_value' => 50,
                'min_purchase_amount' => 100000,
                'max_discount_amount' => 75000,
                'usage_limit_total' => 25,
                'usage_limit_per_client' => 1,
                'starts_at' => now(),
                'ends_at' => now()->addHours(24),
                'is_active' => true,
            ],
        ];

        foreach ($coupons as $couponData) {
            Coupon::updateOrCreate(
                ['code' => $couponData['code']],
                $couponData
            );
        }

        $this->command->info('✅ تم إنشاء '.count($coupons).' كوبون خصم بنجاح!');
    }
}
