<?php

namespace Database\Seeders;

use App\Models\Branch;
use App\Models\City;
use App\Models\Client;
use Illuminate\Database\Seeder;

class ClientSeeder extends Seeder
{
    /**
     * تحويل رقم الهاتف المحلي إلى صيغة دولية
     */
    private function normalizePhone(string $phone): string
    {
        // إزالة أي شيء غير الأرقام
        $p = preg_replace('/\D+/', '', $phone);

        // تحويل 07XXXXXXXXX إلى 00964XXXXXXXXX
        if (str_starts_with($p, '07') && strlen($p) === 11) {
            return '00964'.substr($p, 1);
        }

        // إذا كان بالفعل بصيغة دولية
        if (str_starts_with($p, '00964')) {
            return $p;
        }

        return $p;
    }

    public function run(): void
    {
        // 1) الحصول على فرع نساج
        $basra = City::firstOrCreate(['name' => 'البصرة'], ['is_active' => true]);
        $branch = Branch::where('name', 'نساج')->first();

        if (! $branch) {
            $branch = Branch::first();
        }

        if (! $branch) {
            return;
        }

        // 2) بيانات عملاء تجريبية (أرقام محلية سيتم تحويلها)
        $clients = [
            ['name' => 'محمد هادي', 'phone' => '07711111111', 'address' => 'البصرة - العشار'],
            ['name' => 'حسين علي', 'phone' => '07722222222', 'address' => 'البصرة - الجزائر'],
            ['name' => 'حيدر محمود', 'phone' => '07733333333', 'address' => 'البصرة - المعقل'],
            ['name' => 'سجاد قاسم', 'phone' => '07744444444', 'address' => 'البصرة - بريهة'],
            ['name' => 'علي مصطفى', 'phone' => '07755555555', 'address' => 'البصرة - الطويسة'],
            ['name' => 'حسن فاضل', 'phone' => '07766666666', 'address' => 'البصرة - الجنينة'],
            ['name' => 'صفاء سالم', 'phone' => '07777777777', 'address' => 'البصرة - القبلة'],
            ['name' => 'منتظر جاسم', 'phone' => '07788888888', 'address' => 'البصرة - الكورنيش'],
            ['name' => 'أحمد باسم', 'phone' => '07799999999', 'address' => 'البصرة - البراضعية'],
            ['name' => 'زهراء علي', 'phone' => '07800000000', 'address' => 'البصرة - المشراق'],
        ];

        // 3) إنشاء/تحديث العملاء
        foreach ($clients as $c) {
            $normalizedPhone = $this->normalizePhone($c['phone']);

            Client::updateOrCreate(
                ['phone' => $normalizedPhone],
                [
                    'name' => $c['name'],
                    'company' => null,
                    'phone2' => null,
                    'address' => $c['address'] ?? null,
                    'city_id' => $basra->id,
                    'branch_id' => $branch->id,
                    'password' => '3460015',
                    'is_active' => true,
                ]
            );
        }
    }
}
