<?php

namespace Database\Seeders;

use App\Models\Category;
use Illuminate\Database\Seeder;

class CategorySeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        // التصنيفات الرئيسية والفرعية
        $categoriesData = [
            [
                'name' => 'إلكترونيات',
                'children' => [
                    'هواتف ذكية',
                    'لابتوبات',
                    'تلفزيونات',
                    'أجهزة لوحية',
                    'ساعات ذكية',
                    'سماعات',
                ]
            ],
            [
                'name' => 'أجهزة منزلية',
                'children' => [
                    'ثلاجات',
                    'غسالات',
                    'مكيفات',
                    'مكانس كهربائية',
                    'أفران كهربائية',
                    'ميكروويف',
                ]
            ],
        ];

        // إنشاء التصنيفات لكل فرع

        foreach ($categoriesData as $categoryData) {
            // إنشاء التصنيف الرئيسي
            $parentCategory = Category::create([
                'name' => $categoryData['name'],
                'parent_id' => null,
                'is_active' => true,
            ]);

            $this->command->info("  ✅ {$parentCategory->name}");

            // إنشاء التصنيفات الفرعية
            foreach ($categoryData['children'] as $childName) {
                Category::create([
                    'name' => $childName,
                    'parent_id' => $parentCategory->id,
                    'is_active' => true,
                ]);

                $this->command->info("    └─ {$childName}");
            }
        }

        $this->command->newLine();

        $totalCategories = Category::count();
        $this->command->info("✨ تم إنشاء {$totalCategories} تصنيف بنجاح!");
    }
}
