<?php

namespace Database\Seeders;

use App\Models\Brand;
use Illuminate\Database\Seeder;

class BrandSeeder extends Seeder
{
    public function run(): void
    {
        $brands = [
            [
                'name' => 'Apple',
                'description' => 'شركة أمريكية رائدة في التكنولوجيا وصناعة الأجهزة الذكية.',
                'is_active' => true,
            ],
            [
                'name' => 'Samsung',
                'description' => 'شركة كورية جنوبية متعددة الجنسيات متخصصة في الإلكترونيات والتقنيات.',
                'is_active' => true,
            ],
            [
                'name' => 'Sony',
                'description' => 'شركة يابانية رائدة في الإلكترونيات والترفيه.',
                'is_active' => true,
            ],
            [
                'name' => 'Microsoft',
                'description' => 'شركة أمريكية رائدة في البرمجيات والحلول التقنية.',
                'is_active' => true,
            ],
            [
                'name' => 'Dell',
                'description' => 'شركة أمريكية متخصصة في الحواسيب وتقنيات البنية التحتية.',
                'is_active' => true,
            ],
            [
                'name' => 'HP',
                'description' => 'شركة عالمية معروفة في صناعة الطابعات والحواسيب.',
                'is_active' => true,
            ],
            [
                'name' => 'Lenovo',
                'description' => 'شركة صينية رائدة في صناعة الحواسيب والأجهزة الإلكترونية.',
                'is_active' => true,
            ],
            [
                'name' => 'Asus',
                'description' => 'شركة تايوانية متخصصة في الإلكترونيات والحواسيب.',
                'is_active' => true,
            ],
            [
                'name' => 'Acer',
                'description' => 'شركة تايوانية تنتج الحواسيب والإلكترونيات.',
                'is_active' => true,
            ],
            [
                'name' => 'Xiaomi',
                'description' => 'شركة صينية معروفة في الهواتف الذكية والإلكترونيات الاستهلاكية.',
                'is_active' => true,
            ],
        ];

        foreach ($brands as $brand) {
            Brand::create($brand);
        }
    }
}
