<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use App\Models\Branch;

class BranchSettingsSeeder extends Seeder
{
    public function run(): void
    {
        // لكل فرع نضمن وجود سجل إعدادات مرتبط به
        Branch::query()->each(function (Branch $branch) {
            $branch->settings()->firstOrCreate(
                [], // لا نحتاج شروط إضافية، علاقة hasOne تضيف branch_id تلقائياً
                [
                    'theme_primary' => '#006837',
                    'theme_palette' => null,

                    'address' => null,
                    'phones'  => [],

                    'socials' => [
                        'facebook'  => null,
                        'instagram' => null,
                        'whatsapp'  => null,
                        'tiktok'    => null,
                    ],
                ]
            );
        });
    }
}
