<?php

namespace Database\Seeders;

use App\Models\Branch;
use App\Models\City;
use Illuminate\Database\Seeder;

class BranchSeeder extends Seeder
{
    public function run(): void
    {
        // تأكد من وجود مدينة البصرة
        $city = City::firstOrCreate(['name' => 'البصرة']);

        // إنشاء فرع واحد باسم "نساج"
        Branch::updateOrCreate(
            ['name' => 'نساج'],
            [
                'city_id' => $city->id,
                'status' => true,
            ]
        );
    }
}
