<?php

namespace Database\Seeders;

use App\Models\Attribute;
use App\Models\AttributeValue;
use Illuminate\Database\Seeder;

class AttributeValueSeeder extends Seeder
{
    /**
     * تعبئة جدول قيم الخصائص (attribute_values)
     */
    public function run(): void
    {
        // قيم اللون
        $colorAttribute = Attribute::where('name', 'color')->first();
        if ($colorAttribute) {
            $colors = [
                ['value' => 'red', 'display_value' => 'أحمر', 'color_code' => '#FF0000'],
                ['value' => 'blue', 'display_value' => 'أزرق', 'color_code' => '#0000FF'],
                ['value' => 'green', 'display_value' => 'أخضر', 'color_code' => '#00FF00'],
                ['value' => 'black', 'display_value' => 'أسود', 'color_code' => '#000000'],
                ['value' => 'white', 'display_value' => 'أبيض', 'color_code' => '#FFFFFF'],
                ['value' => 'yellow', 'display_value' => 'أصفر', 'color_code' => '#FFFF00'],
                ['value' => 'gray', 'display_value' => 'رمادي', 'color_code' => '#808080'],
            ];

            foreach ($colors as $color) {
                AttributeValue::firstOrCreate(
                    [
                        'attribute_id' => $colorAttribute->id,
                        'value'        => $color['value'],
                    ],
                    [
                        'display_value' => $color['display_value'],
                        'color_code'    => $color['color_code'],
                        'is_active'     => true,
                    ]
                );
            }
        }

        // قيم الحجم
        $sizeAttribute = Attribute::where('name', 'size')->first();
        if ($sizeAttribute) {
            $sizes = [
                ['value' => 'xs', 'display_value' => 'صغير جداً (XS)'],
                ['value' => 's', 'display_value' => 'صغير (S)'],
                ['value' => 'm', 'display_value' => 'متوسط (M)'],
                ['value' => 'l', 'display_value' => 'كبير (L)'],
                ['value' => 'xl', 'display_value' => 'كبير جداً (XL)'],
                ['value' => 'xxl', 'display_value' => 'كبير جداً جداً (XXL)'],
            ];

            foreach ($sizes as $size) {
                AttributeValue::firstOrCreate(
                    [
                        'attribute_id' => $sizeAttribute->id,
                        'value'        => $size['value'],
                    ],
                    [
                        'display_value' => $size['display_value'],
                        'is_active'     => true,
                    ]
                );
            }
        }

        // قيم المادة
        $materialAttribute = Attribute::where('name', 'material')->first();
        if ($materialAttribute) {
            $materials = [
                ['value' => 'cotton', 'display_value' => 'قطن'],
                ['value' => 'polyester', 'display_value' => 'بوليستر'],
                ['value' => 'wool', 'display_value' => 'صوف'],
                ['value' => 'leather', 'display_value' => 'جلد'],
                ['value' => 'silk', 'display_value' => 'حرير'],
                ['value' => 'nylon', 'display_value' => 'نايلون'],
            ];

            foreach ($materials as $material) {
                AttributeValue::firstOrCreate(
                    [
                        'attribute_id' => $materialAttribute->id,
                        'value'        => $material['value'],
                    ],
                    [
                        'display_value' => $material['display_value'],
                        'is_active'     => true,
                    ]
                );
            }
        }

        // قيم الوزن
        $weightAttribute = Attribute::where('name', 'weight')->first();
        if ($weightAttribute) {
            $weights = [
                ['value' => '100', 'display_value' => '100 جرام'],
                ['value' => '250', 'display_value' => '250 جرام'],
                ['value' => '500', 'display_value' => '500 جرام'],
                ['value' => '1000', 'display_value' => '1 كيلو'],
                ['value' => '2000', 'display_value' => '2 كيلو'],
            ];

            foreach ($weights as $weight) {
                AttributeValue::firstOrCreate(
                    [
                        'attribute_id' => $weightAttribute->id,
                        'value'        => $weight['value'],
                    ],
                    [
                        'display_value' => $weight['display_value'],
                        'is_active'     => true,
                    ]
                );
            }
        }

        $this->command->info('✅ تم إنشاء قيم الخصائص بنجاح');
    }
}
