<?php

namespace Database\Seeders;

use App\Models\Attribute;
use Illuminate\Database\Seeder;

class AttributeSeeder extends Seeder
{
    /**
     * تعبئة جدول الخصائص (attributes)
     *
     * القيم المسموحة في type: ['text', 'color']
     */
    public function run(): void
    {
        $attributes = [
            [
                'name'         => 'color',
                'display_name' => 'اللون',
                'type'         => 'color', // ✅ نوع اللون
                'sort_order'   => 1,
                'is_active'    => true,
            ],
            [
                'name'         => 'size',
                'display_name' => 'الحجم',
                'type'         => 'text', // ✅ نوع نصي
                'sort_order'   => 2,
                'is_active'    => true,
            ],
            [
                'name'         => 'material',
                'display_name' => 'المادة',
                'type'         => 'text', // ✅ نوع نصي
                'sort_order'   => 3,
                'is_active'    => true,
            ],
            [
                'name'         => 'weight',
                'display_name' => 'الوزن',
                'type'         => 'text', // ✅ نوع نصي
                'sort_order'   => 4,
                'is_active'    => true,
            ],
        ];

        foreach ($attributes as $attribute) {
            Attribute::firstOrCreate(
                ['name' => $attribute['name']],
                $attribute
            );
        }

        $this->command->info('✅ تم إنشاء الخصائص بنجاح');
    }
}
