<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('product_prices', function (Blueprint $table) {
            $table->boolean('is_on_sale')->default(false)->after('status');
            $table->unsignedInteger('discount_percentage')->default(0)->after('is_on_sale');
            $table->unsignedBigInteger('sale_price')->default(0)->after('discount_percentage');
            $table->timestamp('sale_start_date')->nullable()->after('sale_price');
            $table->timestamp('sale_end_date')->nullable()->after('sale_start_date');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('product_prices', function (Blueprint $table) {
            $table->dropColumn([
                'is_on_sale',
                'discount_percentage',
                'sale_price',
                'sale_start_date',
                'sale_end_date',
            ]);
        });
    }
};
