<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::create('stickers', function (Blueprint $table) {
            $table->id();

            $table->foreignId('client_id')->constrained()->cascadeOnDelete();
            // المصمم الذي رفع الملصق

            $table->string('name');
            // اسم الملصق

            $table->text('description')->nullable();
            // وصف الملصق

            $table->string('category')->nullable();
            // تصنيف الملصق

            $table->string('status')->default('pending');
            // حالة الملصق: pending / approved / rejected

            $table->text('rejection_reason')->nullable();
            // سبب الرفض (إن وجد)

            $table->boolean('is_active')->default(true);
            // نشط/غير نشط

            $table->unsignedInteger('usage_count')->default(0);
            // عدد مرات الاستخدام

            $table->timestamps();
            $table->softDeletes();

            $table->index(['client_id', 'status']);
            $table->index('status');
            $table->index('category');
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('stickers');
    }
};
