<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::create('product_designs', function (Blueprint $table) {
            $table->id();
            $table->foreignId('product_model_id')->constrained('product_models')->cascadeOnDelete();
            $table->foreignId('user_id')->nullable()->constrained('users')->nullOnDelete(); // Creator of the design
            $table->foreignId('order_item_id')->nullable()->constrained('invoice_items')->nullOnDelete(); // If purchased
            $table->string('name')->nullable();
            $table->json('configuration'); // Colors, texts, images, positions, etc.
            $table->string('preview_image')->nullable(); // Rendered preview image
            $table->boolean('is_public')->default(false); // Can others see this design?
            $table->boolean('is_featured')->default(false);
            $table->integer('views_count')->default(0);
            $table->integer('likes_count')->default(0);
            $table->integer('purchases_count')->default(0);
            $table->timestamps();
            $table->softDeletes();
        });

        // Likes/favorites for designs
        Schema::create('product_design_likes', function (Blueprint $table) {
            $table->id();
            $table->foreignId('product_design_id')->constrained('product_designs')->cascadeOnDelete();
            $table->foreignId('user_id')->constrained('users')->cascadeOnDelete();
            $table->timestamp('created_at')->nullable();

            $table->unique(['product_design_id', 'user_id']);
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('product_design_likes');
        Schema::dropIfExists('product_designs');
    }
};
