<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('store_settings', function (Blueprint $table) {
            $table->id();

            // معلومات المتجر الأساسية
            $table->string('store_name')->nullable();
            $table->string('store_slug')->nullable()->unique();
            $table->text('description')->nullable();
            $table->string('email')->nullable();
            $table->string('phone')->nullable();
            $table->text('address')->nullable();

            // إعدادات العملة والضرائب
            $table->foreignId('default_currency_id')->nullable()->constrained('currencies')->nullOnDelete();
            $table->decimal('tax_rate', 5, 2)->default(0);
            $table->boolean('prices_include_tax')->default(false);

            // إعدادات الشحن
            $table->boolean('enable_shipping')->default(true);
            $table->integer('free_shipping_threshold')->nullable();
            $table->integer('default_shipping_fee')->default(0);

            // إعدادات الدفع
            $table->json('payment_methods')->nullable(); // ['cod', 'online', 'transfer']
            $table->boolean('enable_cod')->default(true);
            $table->integer('cod_fee')->default(0);

            // إعدادات المخزون
            $table->boolean('track_inventory')->default(true);
            $table->boolean('allow_backorders')->default(false);
            $table->integer('low_stock_threshold')->default(5);

            // إعدادات الطلبات
            $table->integer('min_order_amount')->default(0);
            $table->integer('max_order_items')->nullable();
            $table->boolean('require_phone')->default(true);
            $table->boolean('require_address')->default(true);

            // إعدادات العروض والخصومات
            $table->boolean('enable_coupons')->default(true);
            $table->boolean('enable_promotions')->default(true);
            $table->boolean('allow_multiple_coupons')->default(false);

            // إعدادات الإشعارات
            $table->json('notification_settings')->nullable();

            // الألوان والتصميم
            $table->string('theme_primary')->nullable();
            $table->json('theme_palette')->nullable();

            // السوشيال ميديا
            $table->json('socials')->nullable();

            // SEO
            $table->string('meta_title')->nullable();
            $table->text('meta_description')->nullable();
            $table->json('meta_keywords')->nullable();

            // إعدادات متقدمة
            $table->json('advanced_settings')->nullable();

            $table->boolean('is_active')->default(true);
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('store_settings');
    }
};
