<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        // إضافة العلاقات لجدول الطلبات
        Schema::table('orders', function (Blueprint $table) {
            // عنوان الشحن
            $table->foreign('shipping_address_id')
                ->references('id')
                ->on('shipping_addresses')
                ->cascadeOnUpdate()
                ->nullOnDelete();

            // شركة الشحن
            $table->foreign('shipping_company_id')
                ->references('id')
                ->on('shipping_companies')
                ->cascadeOnUpdate()
                ->nullOnDelete();

            // العرض
            $table->foreign('promotion_id')
                ->references('id')
                ->on('promotions')
                ->cascadeOnUpdate()
                ->nullOnDelete();

            // الكوبون
            $table->foreign('coupon_id')
                ->references('id')
                ->on('coupons')
                ->cascadeOnUpdate()
                ->nullOnDelete();
        });

        // إضافة العلاقة لجدول عناصر الطلب
        Schema::table('order_items', function (Blueprint $table) {
            $table->foreign('promotion_id')
                ->references('id')
                ->on('promotions')
                ->cascadeOnUpdate()
                ->nullOnDelete();
        });

        // إضافة العلاقة لجدول الشحنات
        Schema::table('shipments', function (Blueprint $table) {
            $table->foreign('shipping_company_id')
                ->references('id')
                ->on('shipping_companies')
                ->cascadeOnUpdate()
                ->nullOnDelete();
        });
    }

    public function down(): void
    {
        Schema::table('orders', function (Blueprint $table) {
            $table->dropForeign(['shipping_address_id']);
            $table->dropForeign(['shipping_company_id']);
            $table->dropForeign(['promotion_id']);
            $table->dropForeign(['coupon_id']);
        });

        Schema::table('order_items', function (Blueprint $table) {
            $table->dropForeign(['promotion_id']);
        });

        Schema::table('shipments', function (Blueprint $table) {
            $table->dropForeign(['shipping_company_id']);
        });
    }
};
