<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::create('client_discounts', function (Blueprint $table) {
            $table->id();

            // العميل (فريد - خصم واحد لكل عميل)
            $table->foreignId('client_id')
                ->unique()
                ->constrained('clients')
                ->cascadeOnUpdate()
                ->cascadeOnDelete();

            // ═══════════════════════════════════════════════════════════
            // نوع وقيمة الخصم
            // ═══════════════════════════════════════════════════════════

            // نوع الخصم (percentage / fixed)
            $table->string('discount_type')->default('percentage');

            // قيمة الخصم
            $table->decimal('discount_value', 10, 2)->default(0);

            // ═══════════════════════════════════════════════════════════
            // الفترة الزمنية
            // ═══════════════════════════════════════════════════════════

            $table->timestamp('starts_at')->nullable();
            $table->timestamp('ends_at')->nullable();

            // التفعيل
            $table->boolean('is_active')->default(true);

            // المستخدم الذي أنشأ الخصم
            $table->foreignId('created_by')
                ->nullable()
                ->constrained('users')
                ->cascadeOnUpdate()
                ->nullOnDelete();

            // ملاحظات
            $table->text('notes')->nullable();

            $table->timestamps();

            // ═══════════════════════════════════════════════════════════
            // الفهارس
            // ═══════════════════════════════════════════════════════════

            $table->index(['is_active', 'starts_at', 'ends_at']);
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('client_discounts');
    }
};
