<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::create('coupon_redemptions', function (Blueprint $table) {
            $table->id();

            // الكوبون
            $table->foreignId('coupon_id')
                ->constrained('coupons')
                ->cascadeOnUpdate()
                ->cascadeOnDelete();

            // العميل
            $table->foreignId('client_id')
                ->constrained('clients')
                ->cascadeOnUpdate()
                ->cascadeOnDelete();

            // الطلب
            $table->foreignId('order_id')
                ->constrained('orders')
                ->cascadeOnUpdate()
                ->cascadeOnDelete();

            // مبلغ الخصم الفعلي
            $table->unsignedBigInteger('discount_amount')->default(0);

            // تاريخ الاستخدام
            $table->timestamp('redeemed_at');

            $table->timestamps();

            // ═══════════════════════════════════════════════════════════
            // الفهارس
            // ═══════════════════════════════════════════════════════════

            $table->index(['coupon_id', 'client_id']);
            $table->index(['client_id', 'redeemed_at']);
            $table->unique(['coupon_id', 'order_id']);
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('coupon_redemptions');
    }
};
