<?php

use App\Enums\PromotionAppliesTo;
use App\Enums\PromotionType;
use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::create('promotions', function (Blueprint $table) {
            $table->id();

            // ═══════════════════════════════════════════════════════════
            // معلومات العرض الأساسية
            // ═══════════════════════════════════════════════════════════

            $table->string('name');
            $table->text('description')->nullable();

            // نوع العرض
            $table->string('type')->default(PromotionType::Percentage->value);

            // ═══════════════════════════════════════════════════════════
            // قيم الخصم
            // ═══════════════════════════════════════════════════════════

            // قيمة الخصم (نسبة مئوية أو مبلغ ثابت)
            $table->decimal('discount_value', 10, 2)->nullable();

            // للعروض من نوع "اشتري X واحصل على Y"
            $table->unsignedInteger('buy_quantity')->nullable();
            $table->unsignedInteger('get_quantity')->nullable();

            // الحد الأدنى للشراء لتفعيل العرض
            $table->unsignedBigInteger('min_purchase_amount')->nullable();

            // الحد الأقصى للخصم (للنسب المئوية)
            $table->unsignedBigInteger('max_discount_amount')->nullable();

            // ═══════════════════════════════════════════════════════════
            // نطاق التطبيق
            // ═══════════════════════════════════════════════════════════

            // على ماذا يُطبق العرض (الكل / منتج / تصنيف / براند)
            $table->string('applies_to')->default(PromotionAppliesTo::All->value);

            // معرفات العناصر المحددة (json array)
            $table->json('applicable_ids')->nullable();

            // ═══════════════════════════════════════════════════════════
            // أولوية وتراكم
            // ═══════════════════════════════════════════════════════════

            // الأولوية (الأعلى = يُطبق أولاً)
            $table->unsignedInteger('priority')->default(0);

            // هل يمكن دمجه مع عروض أخرى؟
            $table->boolean('is_stackable')->default(false);

            // ═══════════════════════════════════════════════════════════
            // حدود الاستخدام
            // ═══════════════════════════════════════════════════════════

            // الحد الأقصى للاستخدام الإجمالي
            $table->unsignedInteger('usage_limit')->nullable();

            // عدد مرات الاستخدام الحالية
            $table->unsignedInteger('usage_count')->default(0);

            // ═══════════════════════════════════════════════════════════
            // الفترة الزمنية
            // ═══════════════════════════════════════════════════════════

            $table->timestamp('starts_at')->nullable();
            $table->timestamp('ends_at')->nullable();

            // التفعيل
            $table->boolean('is_active')->default(true);

            $table->timestamps();

            // ═══════════════════════════════════════════════════════════
            // الفهارس
            // ═══════════════════════════════════════════════════════════

            $table->index(['is_active', 'starts_at', 'ends_at']);
            $table->index(['type']);
            $table->index(['applies_to']);
            $table->index(['priority']);
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('promotions');
    }
};
