<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::create('coupons', function (Blueprint $table) {
            $table->id();

            // ═══════════════════════════════════════════════════════════
            // معلومات الكوبون الأساسية
            // ═══════════════════════════════════════════════════════════

            // كود الكوبون (فريد)
            $table->string('code')->unique();

            // اسم وصفي
            $table->string('name')->nullable();

            // الوصف
            $table->text('description')->nullable();

            // ═══════════════════════════════════════════════════════════
            // نوع وقيمة الخصم
            // ═══════════════════════════════════════════════════════════

            // نوع الخصم (percentage / fixed)
            $table->string('type')->default('percentage');

            // قيمة الخصم
            $table->decimal('discount_value', 10, 2)->default(0);

            // الحد الأدنى للشراء
            $table->unsignedBigInteger('min_purchase_amount')->nullable();

            // الحد الأقصى للخصم (للنسب المئوية)
            $table->unsignedBigInteger('max_discount_amount')->nullable();

            // ═══════════════════════════════════════════════════════════
            // حدود الاستخدام
            // ═══════════════════════════════════════════════════════════

            // الحد الأقصى للاستخدام الإجمالي
            $table->unsignedInteger('usage_limit_total')->nullable();

            // الحد الأقصى للاستخدام لكل عميل
            $table->unsignedInteger('usage_limit_per_client')->default(1);

            // عدد مرات الاستخدام الحالية
            $table->unsignedInteger('used_count')->default(0);

            // ═══════════════════════════════════════════════════════════
            // الفترة الزمنية
            // ═══════════════════════════════════════════════════════════

            $table->timestamp('starts_at')->nullable();
            $table->timestamp('ends_at')->nullable();

            // التفعيل
            $table->boolean('is_active')->default(true);

            $table->timestamps();

            // ═══════════════════════════════════════════════════════════
            // الفهارس
            // ═══════════════════════════════════════════════════════════

            $table->index(['is_active', 'starts_at', 'ends_at']);
            $table->index(['code']);
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('coupons');
    }
};
