<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::create('order_status_history', function (Blueprint $table) {
            $table->id();

            // الطلب
            $table->foreignId('order_id')
                ->constrained('orders')
                ->cascadeOnUpdate()
                ->cascadeOnDelete();

            // الحالة السابقة
            $table->string('old_status')->nullable();

            // الحالة الجديدة
            $table->string('new_status');

            // المستخدم الذي قام بالتغيير (إن وجد)
            $table->foreignId('user_id')
                ->nullable()
                ->constrained('users')
                ->cascadeOnUpdate()
                ->nullOnDelete();

            // ملاحظات
            $table->text('notes')->nullable();

            // تاريخ التغيير
            $table->timestamp('changed_at');

            $table->timestamps();

            // ═══════════════════════════════════════════════════════════
            // الفهارس
            // ═══════════════════════════════════════════════════════════

            $table->index(['order_id', 'changed_at']);
            $table->index(['new_status']);
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('order_status_history');
    }
};
