<?php

use App\Enums\OrderPaymentStatus;
use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::create('order_payments', function (Blueprint $table) {
            $table->id();

            // الطلب
            $table->foreignId('order_id')
                ->constrained('orders')
                ->cascadeOnUpdate()
                ->cascadeOnDelete();

            // ═══════════════════════════════════════════════════════════
            // طريقة ومزود الدفع
            // ═══════════════════════════════════════════════════════════

            // طريقة الدفع (cash, cod, card, zaincash, paypal, ...)
            $table->string('method');

            // مزود خدمة الدفع (stripe, myfatoorah, internal, ...)
            $table->string('provider')->nullable();

            // رقم مرجعي فريد
            $table->string('reference_id')->unique();

            // ═══════════════════════════════════════════════════════════
            // المبلغ والعملة
            // ═══════════════════════════════════════════════════════════

            $table->unsignedBigInteger('amount')->default(0);

            // العملة (للمدفوعات بعملات مختلفة)
            $table->foreignId('currency_id')
                ->nullable()
                ->constrained('currencies')
                ->cascadeOnUpdate()
                ->nullOnDelete();

            // ═══════════════════════════════════════════════════════════
            // الحالة
            // ═══════════════════════════════════════════════════════════

            $table->string('status')->default(OrderPaymentStatus::Initiated->value);

            // تاريخ الدفع الفعلي
            $table->timestamp('paid_at')->nullable();

            // ═══════════════════════════════════════════════════════════
            // بيانات بوابة الدفع
            // ═══════════════════════════════════════════════════════════

            // رابط صفحة الدفع
            $table->string('payment_url')->nullable();

            // مفتاح التحقق من webhook
            $table->string('webhook_secret')->nullable();

            // كود بوابة الدفع
            $table->string('gateway_code')->nullable();

            // معرف الطلب في بوابة الدفع
            $table->string('gateway_order_id')->nullable();

            // بيانات webhook الكاملة
            $table->json('webhook_payload')->nullable();

            // رسالة الخطأ (إن وجدت)
            $table->text('error_message')->nullable();

            $table->timestamps();

            // ═══════════════════════════════════════════════════════════
            // الفهارس
            // ═══════════════════════════════════════════════════════════

            $table->index(['order_id', 'status']);
            $table->index(['status']);
            $table->index(['created_at']);
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('order_payments');
    }
};
