<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::create('shipping_company_rates', function (Blueprint $table) {
            $table->id();

            // شركة الشحن
            $table->foreignId('shipping_company_id')
                ->constrained('shipping_companies')
                ->cascadeOnUpdate()
                ->cascadeOnDelete();

            // المدينة
            $table->foreignId('city_id')
                ->constrained('cities')
                ->cascadeOnUpdate()
                ->cascadeOnDelete();

            // رسوم الشحن
            $table->unsignedBigInteger('fee')->default(0);

            // رسوم الدفع عند الاستلام
            $table->unsignedBigInteger('cod_fee')->default(0);

            // مدة التوصيل المتوقعة (بالأيام)
            $table->unsignedTinyInteger('estimated_days')->nullable();

            // التفعيل
            $table->boolean('is_active')->default(true);

            $table->timestamps();

            // كل شركة لها سعر واحد لكل مدينة
            $table->unique(['shipping_company_id', 'city_id']);

            // فهارس
            $table->index(['city_id', 'is_active']);
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('shipping_company_rates');
    }
};
