<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::create('shipping_companies', function (Blueprint $table) {
            $table->id();

            // اسم الشركة
            $table->string('name');

            // كود مختصر للشركة
            $table->string('code')->unique();

            // بيانات التواصل
            $table->string('phone')->nullable();
            $table->string('email')->nullable();
            $table->string('contact_person')->nullable();

            // العنوان
            $table->text('address')->nullable();

            // ملاحظات
            $table->text('notes')->nullable();

            // التفعيل
            $table->boolean('is_active')->default(true);

            $table->timestamps();

            // فهارس
            $table->index(['is_active']);
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('shipping_companies');
    }
};
