<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::create('cart_items', function (Blueprint $table) {
            $table->id();

            // السلة
            $table->foreignId('cart_id')
                ->constrained('carts')
                ->cascadeOnUpdate()
                ->cascadeOnDelete();

            // المنتج والمتغير
            $table->foreignId('product_id')
                ->constrained('products')
                ->cascadeOnUpdate()
                ->cascadeOnDelete();

            $table->foreignId('product_variant_id')
                ->constrained('product_variants')
                ->cascadeOnUpdate()
                ->cascadeOnDelete();

            // الكمية
            $table->unsignedInteger('quantity')->default(1);

            // السعر وقت الإضافة (للمرجعية)
            $table->unsignedBigInteger('unit_price')->default(0);

            $table->timestamps();

            // منع تكرار نفس المتغير في السلة
            $table->unique(['cart_id', 'product_variant_id']);

            // فهارس للبحث
            $table->index(['cart_id']);
            $table->index(['product_variant_id']);
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('cart_items');
    }
};
