<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::create('carts', function (Blueprint $table) {
            $table->id();

            // العميل المسجل (اختياري للضيوف)
            $table->foreignId('client_id')
                ->nullable()
                ->constrained('clients')
                ->cascadeOnUpdate()
                ->nullOnDelete();

            // معرف الجلسة للضيوف غير المسجلين
            $table->string('session_id')->nullable();

            // العملة
            $table->foreignId('currency_id')
                ->nullable()
                ->constrained('currencies')
                ->cascadeOnUpdate()
                ->nullOnDelete();

            // كوبون الخصم المطبق (إن وجد)
            $table->string('coupon_code')->nullable();

            // تاريخ انتهاء السلة
            $table->timestamp('expires_at')->nullable();

            $table->timestamps();

            // فهرس للبحث السريع
            $table->index(['client_id']);
            $table->index(['session_id']);
            $table->index(['expires_at']);
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('carts');
    }
};
