<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::create('client_sessions', function (Blueprint $table) {
            $table->string('id')->primary();
            // معرف الجلسة (session id)

            $table->foreignId('client_id')
                ->nullable()
                ->constrained('clients')
                ->cascadeOnUpdate()
                ->nullOnDelete();
            // العميل (NULL للزائر)

            $table->string('ip_address', 45)->nullable();
            // IP

            $table->text('user_agent')->nullable();
            // User Agent

            $table->longText('payload')->nullable();
            // بيانات الجلسة (اختياري)

            $table->integer('last_activity')->index();
            // آخر نشاط (unix timestamp)

            $table->timestamps();
            // created_at / updated_at

            $table->index('client_id');
            // فهرس للعميل (للبحث السريع)
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('client_sessions');
    }
};
