<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::create('shipping_addresses', function (Blueprint $table) {
            $table->id();
            // المعرف الداخلي للعنوان

            $table->foreignId('client_id')
                ->constrained('clients')
                ->cascadeOnUpdate()
                ->cascadeOnDelete();
            // صاحب العنوان (العميل)

            $table->foreignId('city_id')
                ->constrained('cities')
                ->cascadeOnUpdate()
                ->restrictOnDelete();
            // المدينة

            $table->string('name');
            // اسم المستلم

            $table->string('phone');
            // رقم الهاتف

            $table->text('address');
            // العنوان التفصيلي

            $table->boolean('is_default')->default(false);
            // هل هو العنوان الافتراضي

            $table->timestamps();
            // created_at / updated_at
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('shipping_addresses');
    }
};
