<?php

use App\Enums\ShipmentStatus;
use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        // تم تغيير اسم الجدول من deliveries إلى shipments
        Schema::create('shipments', function (Blueprint $table) {
            $table->id();

            // الطلب
            $table->foreignId('order_id')
                ->constrained('orders')
                ->cascadeOnUpdate()
                ->cascadeOnDelete();

            // شركة الشحن (سيتم إضافة العلاقة لاحقاً)
            $table->unsignedBigInteger('shipping_company_id')->nullable();

            // ═══════════════════════════════════════════════════════════
            // أرقام التتبع
            // ═══════════════════════════════════════════════════════════

            // رقم التتبع
            $table->string('tracking_number')->nullable();

            // رقم بوليصة الشحن
            $table->string('waybill_number')->nullable();

            // ═══════════════════════════════════════════════════════════
            // الحالة والتواريخ
            // ═══════════════════════════════════════════════════════════

            $table->string('status')->default(ShipmentStatus::Preparing->value);

            // تاريخ الشحن
            $table->timestamp('shipped_at')->nullable();

            // تاريخ التوصيل
            $table->timestamp('delivered_at')->nullable();

            // تاريخ الإرجاع
            $table->timestamp('returned_at')->nullable();

            // ═══════════════════════════════════════════════════════════
            // محاولات التوصيل
            // ═══════════════════════════════════════════════════════════

            $table->unsignedTinyInteger('delivery_attempts')->default(0);

            // ═══════════════════════════════════════════════════════════
            // الدفع عند الاستلام
            // ═══════════════════════════════════════════════════════════

            // المبلغ المطلوب تحصيله
            $table->unsignedBigInteger('cod_amount')->default(0);

            // هل تم تحصيل المبلغ؟
            $table->boolean('cod_collected')->default(false);

            // تاريخ تحصيل المبلغ
            $table->timestamp('cod_collected_at')->nullable();

            // ═══════════════════════════════════════════════════════════
            // ملاحظات
            // ═══════════════════════════════════════════════════════════

            $table->text('notes')->nullable();

            $table->timestamps();

            // ═══════════════════════════════════════════════════════════
            // الفهارس
            // ═══════════════════════════════════════════════════════════

            $table->index(['order_id']);
            $table->index(['shipping_company_id', 'status']);
            $table->index(['status']);
            $table->index(['tracking_number']);
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('shipments');
    }
};
