<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::create('order_counters', function (Blueprint $table) {
            $table->id();

            $table->foreignId('branch_id')
                ->constrained('branches')
                ->cascadeOnUpdate()
                ->cascadeOnDelete()
                ->unique();

            $table->unsignedInteger('current_sequence')->default(1); // الرقم التالي
            $table->timestamps();
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('order_counters');
    }
};
