<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::create('order_items', function (Blueprint $table) {
            $table->id();

            // الطلب
            $table->foreignId('order_id')
                ->constrained('orders')
                ->cascadeOnUpdate()
                ->cascadeOnDelete();

            // المنتج والمتغير
            $table->foreignId('product_id')
                ->constrained('products')
                ->cascadeOnUpdate()
                ->restrictOnDelete();

            $table->foreignId('product_variant_id')
                ->constrained('product_variants')
                ->cascadeOnUpdate()
                ->restrictOnDelete();

            // ═══════════════════════════════════════════════════════════
            // بيانات المنتج وقت الطلب (للمرجعية)
            // ═══════════════════════════════════════════════════════════

            $table->string('product_name');
            $table->string('variant_name')->nullable();
            $table->string('sku')->nullable();

            // ═══════════════════════════════════════════════════════════
            // الكميات والأسعار
            // ═══════════════════════════════════════════════════════════

            // الكمية المطلوبة
            $table->unsignedInteger('quantity')->default(1);

            // سعر الوحدة
            $table->unsignedBigInteger('unit_price')->default(0);

            // تكلفة الوحدة (للتقارير)
            $table->unsignedBigInteger('unit_cost')->default(0);

            // مبلغ الخصم على هذا العنصر
            $table->unsignedBigInteger('discount_amount')->default(0);

            // إجمالي السطر = (quantity * unit_price) - discount_amount
            $table->unsignedBigInteger('line_total')->default(0);

            // ═══════════════════════════════════════════════════════════
            // العروض (ستضاف العلاقات لاحقاً)
            // ═══════════════════════════════════════════════════════════

            // هل هذا عنصر مجاني (من عرض Buy X Get Y)؟
            $table->boolean('is_free_item')->default(false);

            // العرض المطبق على هذا العنصر
            $table->unsignedBigInteger('promotion_id')->nullable();

            $table->timestamps();

            // ═══════════════════════════════════════════════════════════
            // الفهارس
            // ═══════════════════════════════════════════════════════════

            $table->index(['order_id']);
            $table->index(['product_variant_id']);
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('order_items');
    }
};
