<?php

use App\Enums\OrderStatus;
use App\Enums\PaymentStatus;
use App\Enums\ShippingMethod;
use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::create('orders', function (Blueprint $table) {
            $table->id();

            // رقم الطلب الفريد (يُولّد تلقائياً)
            $table->string('order_number')->unique();

            // الفرع
            $table->foreignId('branch_id')
                ->constrained('branches')
                ->cascadeOnUpdate()
                ->restrictOnDelete();

            // العميل
            $table->foreignId('client_id')
                ->constrained('clients')
                ->cascadeOnUpdate()
                ->restrictOnDelete();

            // العملة وسعر الصرف وقت الطلب
            $table->foreignId('currency_id')
                ->constrained('currencies')
                ->cascadeOnUpdate()
                ->restrictOnDelete();

            $table->unsignedInteger('exchange_rate')->default(1);

            // عنوان الشحن (سيتم إضافة العلاقة لاحقاً)
            $table->unsignedBigInteger('shipping_address_id')->nullable();

            // طريقة الشحن (داخلي / شركة)
            $table->string('shipping_method')->default(ShippingMethod::SelfDelivery->value);

            // شركة الشحن (سيتم إضافة العلاقة لاحقاً)
            $table->unsignedBigInteger('shipping_company_id')->nullable();

            // ═══════════════════════════════════════════════════════════
            // المبالغ
            // ═══════════════════════════════════════════════════════════

            // المجموع الفرعي (قبل الخصم والشحن)
            $table->unsignedBigInteger('subtotal')->default(0);

            // إجمالي الخصم
            $table->unsignedBigInteger('discount_total')->default(0);

            // رسوم الشحن
            $table->unsignedBigInteger('shipping_fee')->default(0);

            // رسوم الدفع عند الاستلام
            $table->unsignedBigInteger('cod_fee')->default(0);

            // الإجمالي النهائي
            $table->unsignedBigInteger('grand_total')->default(0);

            // المبلغ المدفوع
            $table->unsignedBigInteger('paid_amount')->default(0);

            // ═══════════════════════════════════════════════════════════
            // الحالات
            // ═══════════════════════════════════════════════════════════

            // حالة الطلب
            $table->string('status')->default(OrderStatus::Pending->value);

            // حالة الدفع
            $table->string('payment_status')->default(PaymentStatus::UNPAID->value);

            // طريقة الدفع (cod = الدفع عند الاستلام / online = إلكتروني)
            $table->string('payment_method')->default('cod');

            // ═══════════════════════════════════════════════════════════
            // الخصومات والعروض (ستضاف العلاقات لاحقاً)
            // ═══════════════════════════════════════════════════════════

            // العرض المطبق (إن وجد)
            $table->unsignedBigInteger('promotion_id')->nullable();

            // الكوبون المستخدم (إن وجد)
            $table->unsignedBigInteger('coupon_id')->nullable();

            // خصم العميل المسجل (المبلغ المخصوم)
            $table->unsignedBigInteger('client_discount_amount')->default(0);

            // ═══════════════════════════════════════════════════════════
            // ملاحظات
            // ═══════════════════════════════════════════════════════════

            // ملاحظات العميل
            $table->text('customer_notes')->nullable();

            // ملاحظات داخلية
            $table->text('internal_notes')->nullable();

            // تاريخ التأكيد
            $table->timestamp('confirmed_at')->nullable();

            // تاريخ الإكمال
            $table->timestamp('completed_at')->nullable();

            // تاريخ الإلغاء
            $table->timestamp('canceled_at')->nullable();

            $table->timestamps();

            // ═══════════════════════════════════════════════════════════
            // الفهارس
            // ═══════════════════════════════════════════════════════════

            $table->index(['branch_id', 'status']);
            $table->index(['client_id', 'status']);
            $table->index(['status', 'payment_status']);
            $table->index(['created_at']);
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('orders');
    }
};
